% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transitionprobbytotals.R
\name{transitionprobbytotals}
\alias{transitionprobbytotals}
\title{estimate of transition probabilities.}
\usage{
transitionprobbytotals(idTotCnt,snapshots,interval,method)
}
\arguments{
\item{idTotCnt}{a list structure containing \emph{m-by-m} matrices of transition counts, \emph{1-by-m} vectors start counts, and a string with values 'duration' or 'cohort'.}

\item{snapshots}{integer indicating the number of credit-rating snapshots per year to be considered for the estimation. Valid values are 1, 4, or 12. The default value is 1, \emph{i.e., one snapshot per year}. This parameter is only used in the 'cohort' algorithm.}

\item{interval}{the length of the transition interval under consideration, in years. The default value is 1, \emph{i.e., 1-year transition probabilities are estimated}.}

\item{method}{estimation algorithm, in string format. Valid values are 'duration'  or 'cohort'.}
}
\value{
Returns \emph{m-by-m} matrices of credit transition probabilities
}
\description{
estimation of transition probabilities using a transition counts and start vector.
}
\references{
MathWorld.com (2011). Matlab Central \url{http://www.mathworks.com/matlabcentral/}. Mathtools.net \url{http://www.mathtools.net/}.
}
\author{
Abdoulaye (Ab) N'Diaye
}
