% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toThresholds.R
\name{toThresholds}
\alias{toThresholds}
\title{Convert probabilities to credit quality thresholds.}
\usage{
toThresholds(trans)
}
\arguments{
\item{trans}{a \emph{m-by-m} matrix with transition probabilities, in percent. Entries cannot be negative and cannot exceed 100, and all rows must sum up to 100.}
}
\value{
Returns a \emph{m-by-m} matrix of credit quality thresholds
}
\description{
Use this function to transform transition probabilities into credit quality thresholds.
}
\examples{

\dontrun{
rc <- c("AAA", "AA", "A", "BBB", "BB", "B", "CCC", "D")
t<- matrix(c(91.3969, 7.1423, 1.3566, 0.0848, 0.0178, 0.0006, 0.0010, 0.0001,
              5.8072, 87.7881, 5.3402, 0.7040, 0.3391, 0.0116, 0.0081, 0.0014,
              0.3578, 8.0124, 81.7798, 8.8916, 0.7675, 0.0587, 0.1246, 0.0077,
              0.0966, 0.4232, 6.8627, 86.2059, 4.7967, 0.8681, 0.6951, 0.0516,
              0.0297, 0.4156, 0.2821, 6.5406, 85.4804, 4.8337, 1.7363, 0.6815,
              0.4866, 0.0389, 0.2467, 0.3945, 3.5428, 90.0229, 4.0516, 1.2161,
              0.0110, 0.0029, 0.0280, 0.5759, 0.6389, 3.9374, 86.5074, 8.2987,
              0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 100.0000
), 8,8, dimnames = list(rc,rc), byrow=TRUE)


thresholds<-toThresholds(t)
}

}
\references{
MathWorld.com (2011). Matlab Central \url{http://www.mathworks.com/matlabcentral/}. Mathtools.net \url{http://www.mathtools.net/}.
}
\author{
Abdoulaye (Ab) N'Diaye
}
