% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/te_class.R
\name{summary.transfer_entropy}
\alias{summary.transfer_entropy}
\title{Prints a summary of a transfer-entropy result}
\usage{
\method{summary}{transfer_entropy}(object, digits = 4, probs = c(0,
  0.25, 0.5, 0.75, 1), ...)
}
\arguments{
\item{object}{a transfer_entropy}

\item{digits}{the number of digits to display, defaults to 4}

\item{probs}{numeric vector of quantiles for the bootstraps}

\item{...}{additional arguments, passed to \code{\link[stats]{printCoefmat}}}
}
\value{
invisible the object
}
\description{
Prints a summary of a transfer-entropy result
}
\examples{
# construct two time-series
set.seed(1234567890)
n <- 500
x <- rep(0, n + 1)
y <- rep(0, n + 1)

for (i in seq(n)) {
  x[i + 1] <- 0.2 * x[i] + rnorm(1, 0, 2)
  y[i + 1] <- x[i] + rnorm(1, 0, 2)
}

x <- x[-1]
y <- y[-1]

# Calculate Shannon's Transfer Entropy
te_result <- transfer_entropy(x, y, nboot = 100)

summary(te_result)
}
