/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import weka.classifiers.trees.j48.ClassifierSplitModel;
import weka.classifiers.trees.j48.ClassifierTree;
import weka.classifiers.trees.j48.Distribution;
import weka.classifiers.trees.j48.ModelSelection;
import weka.classifiers.trees.j48.NoSplit;
import weka.classifiers.trees.j48.Stats;
import weka.core.Capabilities;
import weka.core.Instances;
import weka.core.Utils;

public class C45PruneableClassifierTree
extends ClassifierTree {
    static final long serialVersionUID = -4813820170260388194L;
    boolean m_pruneTheTree = false;
    float m_CF = 0.25f;
    boolean m_subtreeRaising = true;
    boolean m_cleanup = true;

    public C45PruneableClassifierTree(ModelSelection modelSelection, boolean bl, float f, boolean bl2, boolean bl3) throws Exception {
        super(modelSelection);
        this.m_pruneTheTree = bl;
        this.m_CF = f;
        this.m_subtreeRaising = bl2;
        this.m_cleanup = bl3;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.setMinimumNumberInstances(0);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.buildTree(instances, this.m_subtreeRaising);
        this.collapse();
        if (this.m_pruneTheTree) {
            this.prune();
        }
        if (this.m_cleanup) {
            this.cleanup(new Instances(instances, 0));
        }
    }

    public final void collapse() {
        if (!this.m_isLeaf) {
            double d;
            double d2 = this.getTrainingErrors();
            if (d2 >= (d = this.localModel().distribution().numIncorrect()) - 0.001) {
                this.m_sons = null;
                this.m_isLeaf = true;
                this.m_localModel = new NoSplit(this.localModel().distribution());
            } else {
                for (int i = 0; i < this.m_sons.length; ++i) {
                    this.son(i).collapse();
                }
            }
        }
    }

    public void prune() throws Exception {
        if (!this.m_isLeaf) {
            double d;
            for (int i = 0; i < this.m_sons.length; ++i) {
                this.son(i).prune();
            }
            int n = this.localModel().distribution().maxBag();
            double d2 = this.m_subtreeRaising ? this.son(n).getEstimatedErrorsForBranch(this.m_train) : Double.MAX_VALUE;
            double d3 = this.getEstimatedErrorsForDistribution(this.localModel().distribution());
            if (Utils.smOrEq(d3, (d = this.getEstimatedErrors()) + 0.1) && Utils.smOrEq(d3, d2 + 0.1)) {
                this.m_sons = null;
                this.m_isLeaf = true;
                this.m_localModel = new NoSplit(this.localModel().distribution());
                return;
            }
            if (Utils.smOrEq(d2, d + 0.1)) {
                C45PruneableClassifierTree c45PruneableClassifierTree = this.son(n);
                this.m_sons = c45PruneableClassifierTree.m_sons;
                this.m_localModel = c45PruneableClassifierTree.localModel();
                this.m_isLeaf = c45PruneableClassifierTree.m_isLeaf;
                this.newDistribution(this.m_train);
                this.prune();
            }
        }
    }

    protected ClassifierTree getNewTree(Instances instances) throws Exception {
        C45PruneableClassifierTree c45PruneableClassifierTree = new C45PruneableClassifierTree(this.m_toSelectModel, this.m_pruneTheTree, this.m_CF, this.m_subtreeRaising, this.m_cleanup);
        c45PruneableClassifierTree.buildTree(instances, this.m_subtreeRaising);
        return c45PruneableClassifierTree;
    }

    private double getEstimatedErrors() {
        double d = 0.0;
        if (this.m_isLeaf) {
            return this.getEstimatedErrorsForDistribution(this.localModel().distribution());
        }
        for (int i = 0; i < this.m_sons.length; ++i) {
            d += this.son(i).getEstimatedErrors();
        }
        return d;
    }

    private double getEstimatedErrorsForBranch(Instances instances) throws Exception {
        double d = 0.0;
        if (this.m_isLeaf) {
            return this.getEstimatedErrorsForDistribution(new Distribution(instances));
        }
        Distribution distribution = this.localModel().m_distribution;
        this.localModel().resetDistribution(instances);
        Instances[] instancesArray = this.localModel().split(instances);
        this.localModel().m_distribution = distribution;
        for (int i = 0; i < this.m_sons.length; ++i) {
            d += this.son(i).getEstimatedErrorsForBranch(instancesArray[i]);
        }
        return d;
    }

    private double getEstimatedErrorsForDistribution(Distribution distribution) {
        if (Utils.eq(distribution.total(), 0.0)) {
            return 0.0;
        }
        return distribution.numIncorrect() + Stats.addErrs(distribution.total(), distribution.numIncorrect(), this.m_CF);
    }

    private double getTrainingErrors() {
        double d = 0.0;
        if (this.m_isLeaf) {
            return this.localModel().distribution().numIncorrect();
        }
        for (int i = 0; i < this.m_sons.length; ++i) {
            d += this.son(i).getTrainingErrors();
        }
        return d;
    }

    private ClassifierSplitModel localModel() {
        return this.m_localModel;
    }

    private void newDistribution(Instances instances) throws Exception {
        this.localModel().resetDistribution(instances);
        this.m_train = instances;
        if (!this.m_isLeaf) {
            Instances[] instancesArray = this.localModel().split(instances);
            for (int i = 0; i < this.m_sons.length; ++i) {
                this.son(i).newDistribution(instancesArray[i]);
            }
        } else if (!Utils.eq(instances.sumOfWeights(), 0.0)) {
            this.m_isEmpty = false;
        }
    }

    private C45PruneableClassifierTree son(int n) {
        return (C45PruneableClassifierTree)this.m_sons[n];
    }
}

