/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.lazy.kstar;

import java.io.Serializable;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class KStarCache
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = -7693632394267140678L;
    CacheTable m_Cache = new CacheTable();

    public void store(double d, double d2, double d3) {
        if (!this.m_Cache.containsKey(d)) {
            this.m_Cache.insert(d, d2, d3);
        }
    }

    public boolean containsKey(double d) {
        return this.m_Cache.containsKey(d);
    }

    public TableEntry getCacheValues(double d) {
        if (this.m_Cache.containsKey(d)) {
            return this.m_Cache.getEntry(d);
        }
        return null;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.11 $");
    }

    public class TableEntry
    implements Serializable,
    RevisionHandler {
        private static final long serialVersionUID = 4057602386766259138L;
        public int hash;
        public double key;
        public double value;
        public double pmiss;
        public TableEntry next = null;

        public TableEntry(int n, double d, double d2, double d3, TableEntry tableEntry) {
            this.hash = n;
            this.key = d;
            this.value = d2;
            this.pmiss = d3;
            this.next = tableEntry;
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 1.11 $");
        }
    }

    public class CacheTable
    implements Serializable,
    RevisionHandler {
        private static final long serialVersionUID = -8086106452588253423L;
        private TableEntry[] m_Table;
        private int m_Count;
        private int m_Threshold;
        private float m_LoadFactor;
        private final int DEFAULT_TABLE_SIZE = 101;
        private final float DEFAULT_LOAD_FACTOR = 0.75f;
        private final double EPSILON = 1.0E-5;

        public CacheTable(int n, float f) {
            this.m_Table = new TableEntry[n];
            this.m_LoadFactor = f;
            this.m_Threshold = (int)((float)n * f);
            this.m_Count = 0;
        }

        public CacheTable() {
            this(101, 0.75f);
        }

        public boolean containsKey(double d) {
            TableEntry[] tableEntryArray = this.m_Table;
            int n = this.hashCode(d);
            int n2 = (n & Integer.MAX_VALUE) % tableEntryArray.length;
            TableEntry tableEntry = tableEntryArray[n2];
            while (tableEntry != null) {
                if (tableEntry.hash == n && Math.abs(tableEntry.key - d) < 1.0E-5) {
                    return true;
                }
                tableEntry = tableEntry.next;
            }
            return false;
        }

        public void insert(double d, double d2, double d3) {
            TableEntry tableEntry;
            TableEntry[] tableEntryArray = this.m_Table;
            int n = this.hashCode(d);
            int n2 = (n & Integer.MAX_VALUE) % tableEntryArray.length;
            TableEntry tableEntry2 = tableEntryArray[n2];
            while (tableEntry2 != null) {
                if (tableEntry2.hash == n && Math.abs(tableEntry2.key - d) < 1.0E-5) {
                    return;
                }
                tableEntry2 = tableEntry2.next;
            }
            tableEntryArray[n2] = tableEntry = new TableEntry(n, d, d2, d3, tableEntryArray[n2]);
            ++this.m_Count;
            if (this.m_Count >= this.m_Threshold) {
                this.rehash();
            }
        }

        public TableEntry getEntry(double d) {
            TableEntry[] tableEntryArray = this.m_Table;
            int n = this.hashCode(d);
            int n2 = (n & Integer.MAX_VALUE) % tableEntryArray.length;
            TableEntry tableEntry = tableEntryArray[n2];
            while (tableEntry != null) {
                if (tableEntry.hash == n && Math.abs(tableEntry.key - d) < 1.0E-5) {
                    return tableEntry;
                }
                tableEntry = tableEntry.next;
            }
            return null;
        }

        public int size() {
            return this.m_Count;
        }

        public boolean isEmpty() {
            return this.m_Count == 0;
        }

        public void clear() {
            TableEntry[] tableEntryArray = this.m_Table;
            int n = tableEntryArray.length;
            while (--n >= 0) {
                tableEntryArray[n] = null;
            }
            this.m_Count = 0;
        }

        private void rehash() {
            int n = this.m_Table.length;
            TableEntry[] tableEntryArray = this.m_Table;
            int n2 = n * 2 + 1;
            TableEntry[] tableEntryArray2 = new TableEntry[n2];
            this.m_Threshold = (int)((float)n2 * this.m_LoadFactor);
            this.m_Table = tableEntryArray2;
            int n3 = n;
            while (n3-- > 0) {
                TableEntry tableEntry = tableEntryArray[n3];
                while (tableEntry != null) {
                    TableEntry tableEntry2 = tableEntry;
                    tableEntry = tableEntry.next;
                    int n4 = (tableEntry2.hash & Integer.MAX_VALUE) % n2;
                    tableEntry2.next = tableEntryArray2[n4];
                    tableEntryArray2[n4] = tableEntry2;
                }
            }
        }

        private int hashCode(double d) {
            long l = Double.doubleToLongBits(d);
            return (int)(l ^ l >> 32);
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 1.11 $");
        }
    }
}

