/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.core.matrix.EigenvalueDecomposition;
import weka.core.matrix.Matrix;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.Normalize;
import weka.filters.unsupervised.attribute.Remove;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class PrincipalComponents
extends Filter
implements OptionHandler,
UnsupervisedFilter {
    private static final long serialVersionUID = 4626939780964387784L;
    protected Instances m_TrainInstances;
    protected Instances m_TrainCopy;
    protected Instances m_TransformedFormat;
    protected boolean m_HasClass;
    protected int m_ClassIndex;
    protected int m_NumAttribs;
    protected int m_NumInstances;
    protected double[][] m_Correlation;
    protected double[][] m_Eigenvectors;
    protected double[] m_Eigenvalues = null;
    protected int[] m_SortedEigens;
    protected double m_SumOfEigenValues = 0.0;
    protected ReplaceMissingValues m_ReplaceMissingFilter;
    protected Normalize m_NormalizeFilter;
    protected NominalToBinary m_NominalToBinaryFilter;
    protected Remove m_AttributeFilter;
    protected int m_OutputNumAtts = -1;
    protected boolean m_Normalize = true;
    protected double m_CoverVariance = 0.95;
    protected int m_MaxAttrsInName = 5;
    protected int m_MaxAttributes = -1;

    public String globalInfo() {
        return "Performs a principal components analysis and transformation of the data.\nDimensionality reduction is accomplished by choosing enough eigenvectors to account for some percentage of the variance in the original data -- default 0.95 (95%).\nBased on code of the attribute selection scheme 'PrincipalComponents' by Mark Hall and Gabi Schmidberger.";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tDon't normalize input data.", "D", 0, "-D"));
        vector.addElement(new Option("\tRetain enough PC attributes to account\n\tfor this proportion of variance in the original data.\n\t(default: 0.95)", "R", 1, "-R <num>"));
        vector.addElement(new Option("\tMaximum number of attributes to include in \n\ttransformed attribute names.\n\t(-1 = include all, default: 5)", "A", 1, "-A <num>"));
        vector.addElement(new Option("\tMaximum number of PC attributes to retain.\n\t(-1 = include all, default: -1)", "M", 1, "-M <num>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('R', stringArray);
        if (string.length() != 0) {
            this.setVarianceCovered(Double.parseDouble(string));
        } else {
            this.setVarianceCovered(0.95);
        }
        string = Utils.getOption('A', stringArray);
        if (string.length() != 0) {
            this.setMaximumAttributeNames(Integer.parseInt(string));
        } else {
            this.setMaximumAttributeNames(5);
        }
        string = Utils.getOption('M', stringArray);
        if (string.length() != 0) {
            this.setMaximumAttributes(Integer.parseInt(string));
        } else {
            this.setMaximumAttributes(-1);
        }
        this.setNormalize(!Utils.getFlag('D', stringArray));
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-R");
        vector.add("" + this.getVarianceCovered());
        vector.add("-A");
        vector.add("" + this.getMaximumAttributeNames());
        vector.add("-M");
        vector.add("" + this.getMaximumAttributes());
        if (!this.getNormalize()) {
            vector.add("-D");
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String normalizeTipText() {
        return "Normalize input data.";
    }

    public void setNormalize(boolean bl) {
        this.m_Normalize = bl;
    }

    public boolean getNormalize() {
        return this.m_Normalize;
    }

    public String varianceCoveredTipText() {
        return "Retain enough PC attributes to account for this proportion of variance.";
    }

    public void setVarianceCovered(double d) {
        this.m_CoverVariance = d;
    }

    public double getVarianceCovered() {
        return this.m_CoverVariance;
    }

    public String maximumAttributeNamesTipText() {
        return "The maximum number of attributes to include in transformed attribute names.";
    }

    public void setMaximumAttributeNames(int n) {
        this.m_MaxAttrsInName = n;
    }

    public int getMaximumAttributeNames() {
        return this.m_MaxAttrsInName;
    }

    public String maximumAttributesTipText() {
        return "The maximum number of PC attributes to retain.";
    }

    public void setMaximumAttributes(int n) {
        this.m_MaxAttributes = n;
    }

    public int getMaximumAttributes() {
        return this.m_MaxAttributes;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.NUMERIC_CLASS);
        capabilities.enable(Capabilities.Capability.DATE_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    protected Instances determineOutputFormat(Instances instances) throws Exception {
        if (this.m_Eigenvalues == null) {
            return instances;
        }
        int n = this.m_MaxAttributes > 0 ? this.m_NumAttribs - this.m_MaxAttributes : 0;
        if (n < 0) {
            n = 0;
        }
        double d = 0.0;
        FastVector fastVector = new FastVector();
        for (int i = this.m_NumAttribs - 1; i >= n; --i) {
            int[] nArray;
            int n2;
            int n3;
            StringBuffer stringBuffer = new StringBuffer();
            double[] dArray = new double[this.m_NumAttribs];
            for (n3 = 0; n3 < this.m_NumAttribs; ++n3) {
                dArray[n3] = -Math.abs(this.m_Eigenvectors[n3][this.m_SortedEigens[i]]);
            }
            int n4 = n2 = this.m_MaxAttrsInName > 0 ? Math.min(this.m_NumAttribs, this.m_MaxAttrsInName) : this.m_NumAttribs;
            if (this.m_NumAttribs > 0) {
                nArray = Utils.sort(dArray);
            } else {
                nArray = new int[this.m_NumAttribs];
                for (n3 = 0; n3 < this.m_NumAttribs; ++n3) {
                    nArray[n3] = n3;
                }
            }
            for (n3 = 0; n3 < n2; ++n3) {
                double d2 = this.m_Eigenvectors[nArray[n3]][this.m_SortedEigens[i]];
                if (n3 > 0 && d2 >= 0.0) {
                    stringBuffer.append("+");
                }
                stringBuffer.append(Utils.doubleToString(d2, 5, 3) + instances.attribute(nArray[n3]).name());
            }
            if (n2 < this.m_NumAttribs) {
                stringBuffer.append("...");
            }
            fastVector.addElement(new Attribute(stringBuffer.toString()));
            if ((d += this.m_Eigenvalues[this.m_SortedEigens[i]]) / this.m_SumOfEigenValues >= this.m_CoverVariance) break;
        }
        if (this.m_HasClass) {
            fastVector.addElement(this.m_TrainCopy.classAttribute().copy());
        }
        Instances instances2 = new Instances(this.m_TrainCopy.relationName() + "_principal components", fastVector, 0);
        if (this.m_HasClass) {
            instances2.setClassIndex(instances2.numAttributes() - 1);
        }
        this.m_OutputNumAtts = instances2.numAttributes();
        return instances2;
    }

    protected void fillCorrelation() {
        this.m_Correlation = new double[this.m_NumAttribs][this.m_NumAttribs];
        double[] dArray = new double[this.m_NumInstances];
        double[] dArray2 = new double[this.m_NumInstances];
        for (int i = 0; i < this.m_NumAttribs; ++i) {
            for (int j = 0; j < this.m_NumAttribs; ++j) {
                double d;
                if (i == j) {
                    this.m_Correlation[i][j] = 1.0;
                    continue;
                }
                for (int k = 0; k < this.m_NumInstances; ++k) {
                    dArray[k] = this.m_TrainInstances.instance(k).value(i);
                    dArray2[k] = this.m_TrainInstances.instance(k).value(j);
                }
                this.m_Correlation[i][j] = d = Utils.correlation(dArray, dArray2, this.m_NumInstances);
                this.m_Correlation[j][i] = d;
            }
        }
    }

    protected Instance convertInstance(Instance instance) throws Exception {
        int n;
        double[] dArray = new double[this.m_OutputNumAtts];
        Instance instance2 = (Instance)instance.copy();
        this.m_ReplaceMissingFilter.input(instance2);
        this.m_ReplaceMissingFilter.batchFinished();
        instance2 = this.m_ReplaceMissingFilter.output();
        if (this.m_Normalize) {
            this.m_NormalizeFilter.input(instance2);
            this.m_NormalizeFilter.batchFinished();
            instance2 = this.m_NormalizeFilter.output();
        }
        this.m_NominalToBinaryFilter.input(instance2);
        this.m_NominalToBinaryFilter.batchFinished();
        instance2 = this.m_NominalToBinaryFilter.output();
        if (this.m_AttributeFilter != null) {
            this.m_AttributeFilter.input(instance2);
            this.m_AttributeFilter.batchFinished();
            instance2 = this.m_AttributeFilter.output();
        }
        if (this.m_HasClass) {
            dArray[this.m_OutputNumAtts - 1] = instance.value(instance.classIndex());
        }
        if ((n = this.m_MaxAttributes > 0 ? this.m_NumAttribs - this.m_MaxAttributes : 0) < 0) {
            n = 0;
        }
        double d = 0.0;
        for (int i = this.m_NumAttribs - 1; i >= n; --i) {
            double d2 = 0.0;
            for (int j = 0; j < this.m_NumAttribs; ++j) {
                d2 += this.m_Eigenvectors[j][this.m_SortedEigens[i]] * instance2.value(j);
            }
            dArray[this.m_NumAttribs - i - 1] = d2;
            if ((d += this.m_Eigenvalues[this.m_SortedEigens[i]]) / this.m_SumOfEigenValues >= this.m_CoverVariance) break;
        }
        Instance instance3 = instance instanceof SparseInstance ? new SparseInstance(instance.weight(), dArray) : new Instance(instance.weight(), dArray);
        return instance3;
    }

    protected void setup(Instances instances) throws Exception {
        int n;
        this.m_TrainInstances = new Instances(instances);
        this.m_TrainCopy = new Instances(this.m_TrainInstances);
        this.m_ReplaceMissingFilter = new ReplaceMissingValues();
        this.m_ReplaceMissingFilter.setInputFormat(this.m_TrainInstances);
        this.m_TrainInstances = Filter.useFilter(this.m_TrainInstances, this.m_ReplaceMissingFilter);
        if (this.m_Normalize) {
            this.m_NormalizeFilter = new Normalize();
            this.m_NormalizeFilter.setInputFormat(this.m_TrainInstances);
            this.m_TrainInstances = Filter.useFilter(this.m_TrainInstances, this.m_NormalizeFilter);
        }
        this.m_NominalToBinaryFilter = new NominalToBinary();
        this.m_NominalToBinaryFilter.setInputFormat(this.m_TrainInstances);
        this.m_TrainInstances = Filter.useFilter(this.m_TrainInstances, this.m_NominalToBinaryFilter);
        Vector<Integer> vector = new Vector<Integer>();
        for (n = 0; n < this.m_TrainInstances.numAttributes(); ++n) {
            if (this.m_TrainInstances.numDistinctValues(n) > 1) continue;
            vector.addElement(n);
        }
        if (this.m_TrainInstances.classIndex() >= 0) {
            this.m_HasClass = true;
            this.m_ClassIndex = this.m_TrainInstances.classIndex();
            vector.addElement(new Integer(this.m_ClassIndex));
        }
        if (vector.size() > 0) {
            this.m_AttributeFilter = new Remove();
            int[] nArray = new int[vector.size()];
            for (n = 0; n < vector.size(); ++n) {
                nArray[n] = (Integer)vector.elementAt(n);
            }
            this.m_AttributeFilter.setAttributeIndicesArray(nArray);
            this.m_AttributeFilter.setInvertSelection(false);
            this.m_AttributeFilter.setInputFormat(this.m_TrainInstances);
            this.m_TrainInstances = Filter.useFilter(this.m_TrainInstances, this.m_AttributeFilter);
        }
        this.getCapabilities().testWithFail(this.m_TrainInstances);
        this.m_NumInstances = this.m_TrainInstances.numInstances();
        this.m_NumAttribs = this.m_TrainInstances.numAttributes();
        this.fillCorrelation();
        Matrix matrix = new Matrix(this.m_Correlation);
        EigenvalueDecomposition eigenvalueDecomposition = matrix.eig();
        Matrix matrix2 = eigenvalueDecomposition.getV();
        double[][] dArray = new double[this.m_NumAttribs][this.m_NumAttribs];
        for (n = 0; n < dArray.length; ++n) {
            for (int i = 0; i < dArray[0].length; ++i) {
                dArray[n][i] = matrix2.get(n, i);
            }
        }
        this.m_Eigenvectors = (double[][])dArray.clone();
        this.m_Eigenvalues = (double[])eigenvalueDecomposition.getRealEigenvalues().clone();
        for (n = 0; n < this.m_Eigenvalues.length; ++n) {
            if (!(this.m_Eigenvalues[n] < 0.0)) continue;
            this.m_Eigenvalues[n] = 0.0;
        }
        this.m_SortedEigens = Utils.sort(this.m_Eigenvalues);
        this.m_SumOfEigenValues = Utils.sum(this.m_Eigenvalues);
        this.m_TransformedFormat = this.determineOutputFormat(this.m_TrainInstances);
        this.setOutputFormat(this.m_TransformedFormat);
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.m_Eigenvalues = null;
        this.m_OutputNumAtts = -1;
        this.m_AttributeFilter = null;
        this.m_NominalToBinaryFilter = null;
        this.m_SumOfEigenValues = 0.0;
        return false;
    }

    public boolean input(Instance instance) throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.isNewBatch()) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.isFirstBatchDone()) {
            Instance instance2 = this.convertInstance(instance);
            instance2.setDataset(this.getOutputFormat());
            this.push(instance2);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    public boolean batchFinished() throws Exception {
        if (this.getInputFormat() == null) {
            throw new NullPointerException("No input instance format defined");
        }
        Instances instances = this.getInputFormat();
        if (!this.isFirstBatchDone()) {
            this.setup(instances);
        }
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance instance = this.convertInstance(instances.instance(i));
            instance.setDataset(this.getOutputFormat());
            this.push(instance);
        }
        this.flushInput();
        this.m_NewBatch = true;
        this.m_FirstBatchDone = true;
        return this.numPendingOutput() != 0;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.4 $");
    }

    public static void main(String[] stringArray) {
        PrincipalComponents.runFilter(new PrincipalComponents(), stringArray);
    }
}

