/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.mi;

import weka.core.Optimization;
import weka.core.RevisionUtils;

class TLD_Optm
extends Optimization {
    private double[] num;
    private double[] sSq;
    private double[] xBar;

    TLD_Optm() {
    }

    public void setNum(double[] dArray) {
        this.num = dArray;
    }

    public void setSSquare(double[] dArray) {
        this.sSq = dArray;
    }

    public void setXBar(double[] dArray) {
        this.xBar = dArray;
    }

    public static double diffLnGamma(double d) {
        double[] dArray = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
        double d2 = -0.5;
        d2 += (d + 1.0) * Math.log(d + 6.0) - (d + 0.5) * Math.log(d + 5.5);
        double d3 = 1.000000000190015;
        double d4 = 1.000000000190015;
        for (int i = 0; i < 6; ++i) {
            d3 += dArray[i] / (d + 1.5 + (double)i);
            d4 += dArray[i] / (d + 1.0 + (double)i);
        }
        return d2 += Math.log(d3 * d) - Math.log(d4 * (d + 0.5));
    }

    protected double diffFstDervLnGamma(double d) {
        double d2 = 0.0;
        double d3 = 1.0;
        int n = 0;
        while (d3 >= m_Zero * 0.001) {
            d3 = 0.5 / ((d + (double)n) * (d + (double)n + 0.5));
            d2 += d3;
            ++n;
        }
        return d2;
    }

    protected double diffSndDervLnGamma(double d) {
        double d2 = 0.0;
        double d3 = 1.0;
        int n = 0;
        while (d3 >= m_Zero * 0.001) {
            d3 = (d + (double)n + 0.25) / ((d + (double)n) * (d + (double)n) * (d + (double)n + 0.5) * (d + (double)n + 0.5));
            d2 -= d3;
            ++n;
        }
        return d2;
    }

    protected double objectiveFunction(double[] dArray) {
        int n = this.num.length;
        double d = 0.0;
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = dArray[2];
        double d5 = dArray[3];
        for (int i = 0; i < n; ++i) {
            if (Double.isNaN(this.xBar[i])) continue;
            if (Double.isNaN(d += 0.5 * (d3 + this.num[i]) * Math.log((1.0 + this.num[i] * d4) * (d2 + this.sSq[i]) + this.num[i] * (this.xBar[i] - d5) * (this.xBar[i] - d5))) && m_Debug) {
                System.err.println("???????????1: " + d2 + " " + d3 + " " + d4 + " " + d5 + "|x-: " + this.xBar[i] + "|n: " + this.num[i] + "|S^2: " + this.sSq[i]);
                System.exit(1);
            }
            if (Double.isNaN(d -= 0.5 * (d3 + this.num[i] - 1.0) * Math.log(1.0 + this.num[i] * d4)) && m_Debug) {
                System.err.println("???????????2: " + d2 + " " + d3 + " " + d4 + " " + d5 + "|x-: " + this.xBar[i] + "|n: " + this.num[i] + "|S^2: " + this.sSq[i]);
                System.exit(1);
            }
            int n2 = (int)this.num[i] / 2;
            for (int j = 1; j <= n2; ++j) {
                d -= Math.log(0.5 * d3 + 0.5 * this.num[i] - (double)j);
            }
            if (0.5 * this.num[i] > (double)n2) {
                d -= TLD_Optm.diffLnGamma(0.5 * d3);
            }
            if (Double.isNaN(d) && m_Debug) {
                System.err.println("???????????3: " + d2 + " " + d3 + " " + d4 + " " + d5 + "|x-: " + this.xBar[i] + "|n: " + this.num[i] + "|S^2: " + this.sSq[i]);
                System.exit(1);
            }
            if (!Double.isNaN(d -= 0.5 * Math.log(d2) * d3) || !m_Debug) continue;
            System.err.println("???????????4:" + d2 + " " + d3 + " " + d4 + " " + d5);
            System.exit(1);
        }
        if (m_Debug) {
            System.err.println("?????????????5: " + d);
        }
        if (Double.isNaN(d)) {
            System.exit(1);
        }
        return d;
    }

    protected double[] evaluateGradient(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        int n = this.num.length;
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = dArray[3];
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        for (int i = 0; i < n; ++i) {
            if (Double.isNaN(this.xBar[i])) continue;
            double d9 = (1.0 + this.num[i] * d3) * (d + this.sSq[i]) + this.num[i] * (this.xBar[i] - d4) * (this.xBar[i] - d4);
            d5 += 0.5 * (d2 + this.num[i]) * (1.0 + this.num[i] * d3) / d9 - 0.5 * d2 / d;
            d6 += 0.5 * Math.log(d9) - 0.5 * Math.log(1.0 + this.num[i] * d3) - 0.5 * Math.log(d);
            int n2 = (int)this.num[i] / 2;
            for (int j = 1; j <= n2; ++j) {
                d6 -= 1.0 / (d2 + this.num[i] - 2.0 * (double)j);
            }
            if (this.num[i] / 2.0 > (double)n2) {
                d6 -= 0.5 * this.diffFstDervLnGamma(0.5 * d2);
            }
            d7 += 0.5 * (d2 + this.num[i]) * (d + this.sSq[i]) * this.num[i] / d9 - 0.5 * (d2 + this.num[i] - 1.0) * this.num[i] / (1.0 + this.num[i] * d3);
            d8 += this.num[i] * (d2 + this.num[i]) * (d4 - this.xBar[i]) / d9;
        }
        dArray2[0] = d5;
        dArray2[1] = d6;
        dArray2[2] = d7;
        dArray2[3] = d8;
        return dArray2;
    }

    protected double[] evaluateHessian(double[] dArray, int n) {
        double[] dArray2 = new double[dArray.length];
        int n2 = this.num.length;
        switch (n) {
            case 0: {
                double d = dArray[0];
                double d2 = dArray[1];
                double d3 = dArray[2];
                double d4 = dArray[3];
                for (int i = 0; i < n2; ++i) {
                    if (Double.isNaN(this.xBar[i])) continue;
                    double d5 = (1.0 + this.num[i] * d3) * (d + this.sSq[i]) + this.num[i] * (this.xBar[i] - d4) * (this.xBar[i] - d4);
                    dArray2[0] = dArray2[0] + (0.5 * d2 / (d * d) - 0.5 * (d2 + this.num[i]) * (1.0 + this.num[i] * d3) * (1.0 + this.num[i] * d3) / (d5 * d5));
                    dArray2[1] = dArray2[1] + (0.5 * (1.0 + this.num[i] * d3) / d5 - 0.5 / d);
                    dArray2[2] = dArray2[2] + 0.5 * this.num[i] * this.num[i] * (d2 + this.num[i]) * (this.xBar[i] - d4) * (this.xBar[i] - d4) / (d5 * d5);
                    dArray2[3] = dArray2[3] - this.num[i] * (d2 + this.num[i]) * (d4 - this.xBar[i]) * (1.0 + this.num[i] * d3) / (d5 * d5);
                }
                break;
            }
            case 1: {
                double d = dArray[0];
                double d6 = dArray[1];
                double d7 = dArray[2];
                double d8 = dArray[3];
                for (int i = 0; i < n2; ++i) {
                    if (Double.isNaN(this.xBar[i])) continue;
                    double d9 = (1.0 + this.num[i] * d7) * (d + this.sSq[i]) + this.num[i] * (this.xBar[i] - d8) * (this.xBar[i] - d8);
                    dArray2[0] = dArray2[0] + (0.5 * (1.0 + this.num[i] * d7) / d9 - 0.5 / d);
                    int n3 = (int)this.num[i] / 2;
                    for (int j = 1; j <= n3; ++j) {
                        dArray2[1] = dArray2[1] + 1.0 / ((d6 + this.num[i] - 2.0 * (double)j) * (d6 + this.num[i] - 2.0 * (double)j));
                    }
                    if (this.num[i] / 2.0 > (double)n3) {
                        dArray2[1] = dArray2[1] - 0.25 * this.diffSndDervLnGamma(0.5 * d6);
                    }
                    dArray2[2] = dArray2[2] + (0.5 * (d + this.sSq[i]) * this.num[i] / d9 - 0.5 * this.num[i] / (1.0 + this.num[i] * d7));
                    dArray2[3] = dArray2[3] + this.num[i] * (d8 - this.xBar[i]) / d9;
                }
                break;
            }
            case 2: {
                double d = dArray[0];
                double d10 = dArray[1];
                double d11 = dArray[2];
                double d12 = dArray[3];
                for (int i = 0; i < n2; ++i) {
                    if (Double.isNaN(this.xBar[i])) continue;
                    double d13 = (1.0 + this.num[i] * d11) * (d + this.sSq[i]) + this.num[i] * (this.xBar[i] - d12) * (this.xBar[i] - d12);
                    dArray2[0] = dArray2[0] + 0.5 * this.num[i] * this.num[i] * (d10 + this.num[i]) * (this.xBar[i] - d12) * (this.xBar[i] - d12) / (d13 * d13);
                    dArray2[1] = dArray2[1] + (0.5 * (d + this.sSq[i]) * this.num[i] / d13 - 0.5 * this.num[i] / (1.0 + this.num[i] * d11));
                    dArray2[2] = dArray2[2] + (0.5 * (d10 + this.num[i] - 1.0) * this.num[i] * this.num[i] / ((1.0 + this.num[i] * d11) * (1.0 + this.num[i] * d11)) - 0.5 * (d10 + this.num[i]) * (d + this.sSq[i]) * (d + this.sSq[i]) * this.num[i] * this.num[i] / (d13 * d13));
                    dArray2[3] = dArray2[3] - this.num[i] * this.num[i] * (d10 + this.num[i]) * (d12 - this.xBar[i]) * (d + this.sSq[i]) / (d13 * d13);
                }
                break;
            }
            case 3: {
                double d = dArray[0];
                double d14 = dArray[1];
                double d15 = dArray[2];
                double d16 = dArray[3];
                for (int i = 0; i < n2; ++i) {
                    if (Double.isNaN(this.xBar[i])) continue;
                    double d17 = (1.0 + this.num[i] * d15) * (d + this.sSq[i]) + this.num[i] * (this.xBar[i] - d16) * (this.xBar[i] - d16);
                    dArray2[0] = dArray2[0] - this.num[i] * (d14 + this.num[i]) * (d16 - this.xBar[i]) * (1.0 + this.num[i] * d15) / (d17 * d17);
                    dArray2[1] = dArray2[1] + this.num[i] * (d16 - this.xBar[i]) / d17;
                    dArray2[2] = dArray2[2] - this.num[i] * this.num[i] * (d14 + this.num[i]) * (d16 - this.xBar[i]) * (d + this.sSq[i]) / (d17 * d17);
                    dArray2[3] = dArray2[3] + this.num[i] * (d14 + this.num[i]) * ((1.0 + this.num[i] * d15) * (d + this.sSq[i]) - this.num[i] * (d16 - this.xBar[i]) * (d16 - this.xBar[i])) / (d17 * d17);
                }
                break;
            }
        }
        return dArray2;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.6 $");
    }
}

