/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.boundaryvisualizer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.ObjectOutputStream;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import weka.classifiers.Classifier;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.Utils;
import weka.core.logging.Logger;
import weka.gui.ExtensionFileFilter;
import weka.gui.GenericObjectEditor;
import weka.gui.PropertyPanel;
import weka.gui.boundaryvisualizer.BoundaryPanel;
import weka.gui.boundaryvisualizer.KDDataGenerator;
import weka.gui.visualize.ClassPanel;

public class BoundaryVisualizer
extends JPanel {
    private static final long serialVersionUID = 3933877580074013208L;
    protected static int m_WindowCount = 0;
    protected static boolean m_ExitIfNoWindowsOpen = true;
    private Instances m_trainingInstances;
    private Classifier m_classifier;
    protected int m_plotAreaWidth = 512;
    protected int m_plotAreaHeight = 384;
    protected BoundaryPanel m_boundaryPanel;
    protected JComboBox m_classAttBox = new JComboBox();
    protected JComboBox m_xAttBox = new JComboBox();
    protected JComboBox m_yAttBox = new JComboBox();
    protected Dimension COMBO_SIZE;
    protected JButton m_startBut;
    protected JCheckBox m_plotTrainingData;
    protected JPanel m_controlPanel;
    protected ClassPanel m_classPanel;
    private AxisPanel m_xAxisPanel;
    private AxisPanel m_yAxisPanel;
    private double m_maxX;
    private double m_maxY;
    private double m_minX;
    private double m_minY;
    private int m_xIndex;
    private int m_yIndex;
    private KDDataGenerator m_dataGenerator;
    private int m_numberOfSamplesFromEachRegion;
    private int m_generatorSamplesBase;
    private int m_kernelBandwidth;
    private JTextField m_regionSamplesText;
    private JTextField m_generatorSamplesText;
    private JTextField m_kernelBandwidthText;
    protected GenericObjectEditor m_classifierEditor;
    protected PropertyPanel m_ClassifierPanel;
    protected JFileChooser m_FileChooser;
    protected ExtensionFileFilter m_arffFileFilter;
    protected JLabel dataFileLabel;
    protected JPanel m_addRemovePointsPanel;
    protected JComboBox classValueSelector;
    protected JRadioButton m_addPointsButton;
    protected JRadioButton m_removePointsButton;
    protected ButtonGroup m_addRemovePointsButtonGroup;
    protected JButton removeAllButton;
    protected JButton chooseButton;

    public BoundaryVisualizer() {
        this.COMBO_SIZE = new Dimension((int)((double)this.m_plotAreaWidth * 0.75), this.m_classAttBox.getPreferredSize().height);
        this.m_startBut = new JButton("Start");
        this.m_plotTrainingData = new JCheckBox("Plot training data");
        this.m_classPanel = new ClassPanel();
        this.m_regionSamplesText = new JTextField("0");
        this.m_generatorSamplesText = new JTextField("0");
        this.m_kernelBandwidthText = new JTextField("3  ");
        this.m_classifierEditor = new GenericObjectEditor();
        this.m_ClassifierPanel = new PropertyPanel(this.m_classifierEditor);
        this.m_FileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
        this.m_arffFileFilter = new ExtensionFileFilter(".arff", "Arff data files");
        this.dataFileLabel = new JLabel();
        this.m_addRemovePointsPanel = new JPanel();
        this.classValueSelector = new JComboBox();
        this.m_addPointsButton = new JRadioButton();
        this.m_removePointsButton = new JRadioButton();
        this.m_addRemovePointsButtonGroup = new ButtonGroup();
        this.removeAllButton = new JButton("Remove all");
        this.chooseButton = new JButton("Open File");
        this.setLayout(new BorderLayout());
        this.m_classAttBox.setMinimumSize(this.COMBO_SIZE);
        this.m_classAttBox.setPreferredSize(this.COMBO_SIZE);
        this.m_classAttBox.setMaximumSize(this.COMBO_SIZE);
        this.m_classAttBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (BoundaryVisualizer.this.m_classAttBox.getItemCount() != 0) {
                    try {
                        BoundaryVisualizer.this.m_classPanel.setCindex(BoundaryVisualizer.this.m_classAttBox.getSelectedIndex());
                        BoundaryVisualizer.this.plotTrainingData();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    BoundaryVisualizer.this.setUpClassValueSelectorCB();
                }
            }
        });
        this.m_xAttBox.setMinimumSize(this.COMBO_SIZE);
        this.m_xAttBox.setPreferredSize(this.COMBO_SIZE);
        this.m_xAttBox.setMaximumSize(this.COMBO_SIZE);
        this.m_yAttBox.setMinimumSize(this.COMBO_SIZE);
        this.m_yAttBox.setPreferredSize(this.COMBO_SIZE);
        this.m_yAttBox.setMaximumSize(this.COMBO_SIZE);
        this.m_classPanel.setMinimumSize(new Dimension((int)this.COMBO_SIZE.getWidth() * 2, (int)this.COMBO_SIZE.getHeight() * 2));
        this.m_classPanel.setPreferredSize(new Dimension((int)this.COMBO_SIZE.getWidth() * 2, (int)this.COMBO_SIZE.getHeight() * 2));
        this.m_controlPanel = new JPanel();
        this.m_controlPanel.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Dataset"));
        jPanel.add((Component)this.dataFileLabel, "West");
        this.m_FileChooser.setFileSelectionMode(0);
        this.m_FileChooser.addChoosableFileFilter(this.m_arffFileFilter);
        this.chooseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    BoundaryVisualizer.this.setInstancesFromFileQ();
                    int n = BoundaryVisualizer.this.m_classAttBox.getSelectedIndex();
                    if (BoundaryVisualizer.this.m_trainingInstances != null && BoundaryVisualizer.this.m_classifier != null && BoundaryVisualizer.this.m_trainingInstances.attribute(n).isNominal()) {
                        BoundaryVisualizer.this.m_startBut.setEnabled(true);
                        BoundaryVisualizer.this.plotTrainingData();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.out);
                    System.err.println("exception");
                }
            }
        });
        jPanel.add((Component)this.chooseButton, "East");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder("Classifier"));
        jPanel2.setLayout(new BorderLayout());
        this.m_classifierEditor.setClassType(Classifier.class);
        this.m_classifierEditor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                BoundaryVisualizer.this.m_classifier = (Classifier)BoundaryVisualizer.this.m_classifierEditor.getValue();
                try {
                    int n = BoundaryVisualizer.this.m_classAttBox.getSelectedIndex();
                    if (BoundaryVisualizer.this.m_trainingInstances != null && BoundaryVisualizer.this.m_classifier != null && BoundaryVisualizer.this.m_trainingInstances.attribute(n).isNominal()) {
                        BoundaryVisualizer.this.m_startBut.setEnabled(true);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        jPanel2.add((Component)this.m_ClassifierPanel, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createTitledBorder("Class Attribute"));
        jPanel3.add(this.m_classAttBox);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(2, 1));
        jPanel4.setBorder(BorderFactory.createTitledBorder("Visualization Attributes"));
        jPanel4.add(this.m_xAttBox);
        jPanel4.add(this.m_yAttBox);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        jPanel5.add((Component)jPanel, "North");
        jPanel5.add((Component)jPanel3, "Center");
        JPanel jPanel6 = new JPanel();
        jPanel6.setBorder(BorderFactory.createTitledBorder("Sampling control"));
        jPanel6.setLayout(new GridLayout(3, 1));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout());
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BorderLayout());
        jPanel8.add((Component)new JLabel(" Base for sampling (r)"), "Center");
        jPanel8.add((Component)this.m_generatorSamplesText, "West");
        jPanel6.add(jPanel8);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BorderLayout());
        jPanel9.add((Component)new JLabel(" Num. locations per pixel"), "Center");
        jPanel9.add((Component)this.m_regionSamplesText, "West");
        jPanel6.add(jPanel9);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new BorderLayout());
        jPanel10.add((Component)new JLabel(" Kernel bandwidth (k)"), "Center");
        jPanel10.add((Component)this.m_kernelBandwidthText, "West");
        jPanel6.add(jPanel10);
        jPanel7.add((Component)jPanel2, "North");
        jPanel7.add((Component)jPanel4, "Center");
        JPanel jPanel11 = new JPanel();
        jPanel11.setBorder(BorderFactory.createTitledBorder("Plotting"));
        jPanel11.setLayout(new BorderLayout());
        jPanel11.add((Component)this.m_startBut, "Center");
        jPanel11.add((Component)this.m_plotTrainingData, "West");
        this.m_controlPanel.add((Component)jPanel5, "West");
        this.m_controlPanel.add((Component)jPanel7, "Center");
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new BorderLayout());
        jPanel12.setBorder(BorderFactory.createTitledBorder("Class color"));
        jPanel12.add((Component)this.m_classPanel, "Center");
        this.m_controlPanel.add((Component)jPanel12, "South");
        this.add((Component)this.m_controlPanel, "North");
        this.m_addRemovePointsPanel.setBorder(BorderFactory.createTitledBorder("Add / remove data points"));
        this.m_addRemovePointsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.m_addRemovePointsPanel.add(this.m_addPointsButton);
        gridBagConstraints.gridx = 1;
        this.m_addRemovePointsPanel.add((Component)new JLabel("Add points"), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.m_addRemovePointsPanel.add(this.classValueSelector);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.m_addRemovePointsPanel.add((Component)this.m_removePointsButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.m_addRemovePointsPanel.add((Component)new JLabel("Remove points"), gridBagConstraints);
        this.removeAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (BoundaryVisualizer.this.m_trainingInstances != null) {
                    if (BoundaryVisualizer.this.m_startBut.getText().equals("Stop")) {
                        return;
                    }
                    BoundaryVisualizer.this.m_boundaryPanel.removeAllInstances();
                    BoundaryVisualizer.this.computeBounds();
                    BoundaryVisualizer.this.m_xAxisPanel.repaint(0L, 0, 0, BoundaryVisualizer.this.m_xAxisPanel.getWidth(), BoundaryVisualizer.this.m_xAxisPanel.getHeight());
                    BoundaryVisualizer.this.m_yAxisPanel.repaint(0L, 0, 0, BoundaryVisualizer.this.m_yAxisPanel.getWidth(), BoundaryVisualizer.this.m_yAxisPanel.getHeight());
                    try {
                        BoundaryVisualizer.this.m_boundaryPanel.plotTrainingData();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        gridBagConstraints.gridx = 2;
        this.m_addRemovePointsPanel.add((Component)this.removeAllButton, gridBagConstraints);
        this.m_addRemovePointsButtonGroup.add(this.m_addPointsButton);
        this.m_addRemovePointsButtonGroup.add(this.m_removePointsButton);
        this.m_addPointsButton.setSelected(true);
        this.m_boundaryPanel = new BoundaryPanel(this.m_plotAreaWidth, this.m_plotAreaHeight);
        this.m_numberOfSamplesFromEachRegion = this.m_boundaryPanel.getNumSamplesPerRegion();
        this.m_regionSamplesText.setText("" + this.m_numberOfSamplesFromEachRegion + "  ");
        this.m_generatorSamplesBase = (int)this.m_boundaryPanel.getGeneratorSamplesBase();
        this.m_generatorSamplesText.setText("" + this.m_generatorSamplesBase + "  ");
        this.m_dataGenerator = new KDDataGenerator();
        this.m_kernelBandwidth = this.m_dataGenerator.getKernelBandwidth();
        this.m_kernelBandwidthText.setText("" + this.m_kernelBandwidth + "  ");
        this.m_boundaryPanel.setDataGenerator(this.m_dataGenerator);
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new BorderLayout());
        jPanel13.setBorder(BorderFactory.createEtchedBorder());
        jPanel13.add((Component)this.m_boundaryPanel, "Center");
        this.m_xAxisPanel = new AxisPanel(false);
        jPanel13.add((Component)this.m_xAxisPanel, "South");
        this.m_yAxisPanel = new AxisPanel(true);
        jPanel13.add((Component)this.m_yAxisPanel, "West");
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout(new BorderLayout());
        jPanel14.add((Component)jPanel13, "Center");
        this.add((Component)jPanel14, "Center");
        JPanel jPanel15 = new JPanel();
        jPanel15.setLayout(new BoxLayout(jPanel15, 3));
        jPanel15.add(this.m_addRemovePointsPanel);
        JButton jButton = new JButton("Open a new window");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Instances instances = null;
                    Classifier classifier = null;
                    if (BoundaryVisualizer.this.m_trainingInstances != null) {
                        instances = new Instances(BoundaryVisualizer.this.m_trainingInstances);
                    }
                    if (BoundaryVisualizer.this.m_classifier != null) {
                        classifier = Classifier.makeCopy(BoundaryVisualizer.this.m_classifier);
                    }
                    BoundaryVisualizer.createNewVisualizerWindow(classifier, instances);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        JPanel jPanel16 = new JPanel();
        jPanel16.add(jButton);
        jPanel15.add(jPanel16);
        jPanel15.add(jPanel6);
        jPanel15.add(jPanel11);
        jPanel14.add((Component)jPanel15, "East");
        this.m_startBut.setEnabled(false);
        this.m_startBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                block7: {
                    if (BoundaryVisualizer.this.m_startBut.getText().equals("Start")) {
                        if (BoundaryVisualizer.this.m_trainingInstances != null && BoundaryVisualizer.this.m_classifier != null) {
                            try {
                                int n = BoundaryVisualizer.this.setUpBoundaryPanel();
                                if (n == 1) {
                                    JOptionPane.showMessageDialog(null, "Error: Kernel Bandwidth can't be less than zero!");
                                    break block7;
                                }
                                if (n == 2) {
                                    JOptionPane.showMessageDialog(null, "Error: Kernel Bandwidth must be less than the number of training instances!");
                                    break block7;
                                }
                                BoundaryVisualizer.this.m_boundaryPanel.start();
                                BoundaryVisualizer.this.m_startBut.setText("Stop");
                                BoundaryVisualizer.this.setControlEnabledStatus(false);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    } else {
                        BoundaryVisualizer.this.m_boundaryPanel.stopPlotting();
                        BoundaryVisualizer.this.m_startBut.setText("Start");
                        BoundaryVisualizer.this.setControlEnabledStatus(true);
                    }
                }
            }
        });
        this.m_boundaryPanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BoundaryVisualizer.this.m_startBut.setText("Start");
                BoundaryVisualizer.this.setControlEnabledStatus(true);
            }
        });
        this.m_classPanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    FastVector fastVector = BoundaryVisualizer.this.m_boundaryPanel.getColors();
                    FileOutputStream fileOutputStream = new FileOutputStream("colors.ser");
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                    objectOutputStream.writeObject(fastVector);
                    objectOutputStream.flush();
                    objectOutputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                BoundaryVisualizer.this.m_boundaryPanel.replot();
            }
        });
        this.m_boundaryPanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (BoundaryVisualizer.this.m_trainingInstances != null) {
                    if (BoundaryVisualizer.this.m_startBut.getText().equals("Stop")) {
                        return;
                    }
                    if (BoundaryVisualizer.this.m_addPointsButton.isSelected()) {
                        double d = 0.0;
                        boolean bl = true;
                        if (BoundaryVisualizer.this.m_trainingInstances.attribute(BoundaryVisualizer.this.m_classAttBox.getSelectedIndex()).isNominal()) {
                            d = BoundaryVisualizer.this.classValueSelector.getSelectedIndex();
                        } else {
                            String string = "";
                            try {
                                string = (String)BoundaryVisualizer.this.classValueSelector.getSelectedItem();
                                d = Double.parseDouble(string);
                            }
                            catch (Exception exception) {
                                if (string == null) {
                                    string = "";
                                }
                                JOptionPane.showMessageDialog(null, "Error adding a point: \"" + string + "\"" + " is not a valid class value.");
                                bl = false;
                            }
                        }
                        if (bl) {
                            BoundaryVisualizer.this.m_boundaryPanel.addTrainingInstanceFromMouseLocation(mouseEvent.getX(), mouseEvent.getY(), BoundaryVisualizer.this.m_classAttBox.getSelectedIndex(), d);
                        }
                    } else {
                        BoundaryVisualizer.this.m_boundaryPanel.removeTrainingInstanceFromMouseLocation(mouseEvent.getX(), mouseEvent.getY());
                    }
                    try {
                        BoundaryVisualizer.this.plotTrainingData();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    BoundaryVisualizer.this.m_xAxisPanel.repaint(0L, 0, 0, BoundaryVisualizer.this.m_xAxisPanel.getWidth(), BoundaryVisualizer.this.m_xAxisPanel.getHeight());
                    BoundaryVisualizer.this.m_yAxisPanel.repaint(0L, 0, 0, BoundaryVisualizer.this.m_yAxisPanel.getWidth(), BoundaryVisualizer.this.m_yAxisPanel.getHeight());
                }
            }
        });
    }

    private void setControlEnabledStatus(boolean bl) {
        this.m_classAttBox.setEnabled(bl);
        this.m_xAttBox.setEnabled(bl);
        this.m_yAttBox.setEnabled(bl);
        this.m_regionSamplesText.setEnabled(bl);
        this.m_generatorSamplesText.setEnabled(bl);
        this.m_kernelBandwidthText.setEnabled(bl);
        this.m_plotTrainingData.setEnabled(bl);
        this.removeAllButton.setEnabled(bl);
        this.classValueSelector.setEnabled(bl);
        this.m_addPointsButton.setEnabled(bl);
        this.m_removePointsButton.setEnabled(bl);
        this.m_FileChooser.setEnabled(bl);
        this.chooseButton.setEnabled(bl);
    }

    public void setClassifier(Classifier classifier) throws Exception {
        this.m_classifier = classifier;
        try {
            int n = this.m_classAttBox.getSelectedIndex();
            if (this.m_classifier != null && this.m_trainingInstances != null && this.m_trainingInstances.attribute(n).isNominal()) {
                this.m_startBut.setEnabled(true);
            } else {
                this.m_startBut.setEnabled(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void computeBounds() {
        this.m_boundaryPanel.computeMinMaxAtts();
        String string = (String)this.m_xAttBox.getSelectedItem();
        if (string == null) {
            return;
        }
        string = Utils.removeSubstring(string, "X: ");
        string = Utils.removeSubstring(string, " (Num)");
        String string2 = (String)this.m_yAttBox.getSelectedItem();
        string2 = Utils.removeSubstring(string2, "Y: ");
        string2 = Utils.removeSubstring(string2, " (Num)");
        this.m_xIndex = -1;
        this.m_yIndex = -1;
        for (int i = 0; i < this.m_trainingInstances.numAttributes(); ++i) {
            if (this.m_trainingInstances.attribute(i).name().equals(string)) {
                this.m_xIndex = i;
            }
            if (!this.m_trainingInstances.attribute(i).name().equals(string2)) continue;
            this.m_yIndex = i;
        }
        this.m_minX = this.m_boundaryPanel.getMinXBound();
        this.m_minY = this.m_boundaryPanel.getMinYBound();
        this.m_maxX = this.m_boundaryPanel.getMaxXBound();
        this.m_maxY = this.m_boundaryPanel.getMaxYBound();
        this.m_xAxisPanel.repaint(0L, 0, 0, this.m_xAxisPanel.getWidth(), this.m_xAxisPanel.getHeight());
        this.m_yAxisPanel.repaint(0L, 0, 0, this.m_yAxisPanel.getWidth(), this.m_yAxisPanel.getHeight());
    }

    public Instances getInstances() {
        return this.m_trainingInstances;
    }

    public void setInstances(Instances instances) throws Exception {
        if (instances == null) {
            this.m_trainingInstances = instances;
            this.m_classPanel.setInstances(this.m_trainingInstances);
            return;
        }
        if (instances.numAttributes() < 3) {
            throw new Exception("Not enough attributes in the data to visualize!");
        }
        this.m_trainingInstances = instances;
        this.m_classPanel.setInstances(this.m_trainingInstances);
        String[] stringArray = new String[this.m_trainingInstances.numAttributes()];
        final Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        for (int i = 0; i < this.m_trainingInstances.numAttributes(); ++i) {
            stringArray[i] = this.m_trainingInstances.attribute(i).name();
            String string = "";
            switch (this.m_trainingInstances.attribute(i).type()) {
                case 1: {
                    string = " (Nom)";
                    break;
                }
                case 0: {
                    string = " (Num)";
                    break;
                }
                case 2: {
                    string = " (Str)";
                    break;
                }
                case 3: {
                    string = " (Dat)";
                    break;
                }
                case 4: {
                    string = " (Rel)";
                    break;
                }
                default: {
                    string = " (???)";
                }
            }
            int n = i;
            stringArray[n] = stringArray[n] + string;
            if (!this.m_trainingInstances.attribute(i).isNumeric()) continue;
            vector.addElement("X: " + stringArray[i]);
            vector2.addElement("Y: " + stringArray[i]);
        }
        this.m_classAttBox.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.m_xAttBox.setModel(new DefaultComboBoxModel(vector));
        this.m_yAttBox.setModel(new DefaultComboBoxModel(vector2));
        if (vector.size() > 1) {
            this.m_yAttBox.setSelectedIndex(1);
        }
        if (stringArray.length > 0) {
            this.m_classAttBox.setSelectedIndex(stringArray.length - 1);
        }
        this.m_classAttBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BoundaryVisualizer.this.configureForClassAttribute();
            }
        });
        this.m_xAttBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    if (vector.size() > 1 && BoundaryVisualizer.this.m_xAttBox.getSelectedIndex() == BoundaryVisualizer.this.m_yAttBox.getSelectedIndex()) {
                        BoundaryVisualizer.this.m_xAttBox.setSelectedIndex((BoundaryVisualizer.this.m_xAttBox.getSelectedIndex() + 1) % vector.size());
                    }
                    BoundaryVisualizer.this.computeBounds();
                    BoundaryVisualizer.this.repaint();
                    try {
                        BoundaryVisualizer.this.plotTrainingData();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.m_yAttBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    if (vector.size() > 1 && BoundaryVisualizer.this.m_yAttBox.getSelectedIndex() == BoundaryVisualizer.this.m_xAttBox.getSelectedIndex()) {
                        BoundaryVisualizer.this.m_yAttBox.setSelectedIndex((BoundaryVisualizer.this.m_yAttBox.getSelectedIndex() + 1) % vector.size());
                    }
                    BoundaryVisualizer.this.computeBounds();
                    BoundaryVisualizer.this.repaint();
                    try {
                        BoundaryVisualizer.this.plotTrainingData();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.setUpClassValueSelectorCB();
        this.configureForClassAttribute();
        this.computeBounds();
        this.revalidate();
        this.repaint();
    }

    private void setUpClassValueSelectorCB() {
        this.classValueSelector.removeAllItems();
        int n = this.m_classAttBox.getSelectedIndex();
        this.m_trainingInstances.setClassIndex(n);
        if (this.m_trainingInstances.attribute(n).isNominal()) {
            this.classValueSelector.setEditable(false);
            for (int i = 0; i < this.m_trainingInstances.numClasses(); ++i) {
                this.classValueSelector.insertItemAt(this.m_trainingInstances.attribute(n).value(i), i);
            }
            this.classValueSelector.setSelectedIndex(0);
        } else {
            this.classValueSelector.setEditable(true);
        }
    }

    private void configureForClassAttribute() {
        int n = this.m_classAttBox.getSelectedIndex();
        if (n >= 0) {
            if (!this.m_trainingInstances.attribute(n).isNominal() || this.m_classifier == null) {
                this.m_startBut.setEnabled(false);
            } else {
                this.m_startBut.setEnabled(true);
            }
            FastVector fastVector = new FastVector();
            if (!this.m_trainingInstances.attribute(this.m_classAttBox.getSelectedIndex()).isNominal()) {
                for (int i = 0; i < BoundaryPanel.DEFAULT_COLORS.length; ++i) {
                    fastVector.addElement(BoundaryPanel.DEFAULT_COLORS[i]);
                }
            } else {
                for (int i = 0; i < this.m_trainingInstances.attribute(n).numValues(); ++i) {
                    fastVector.addElement(BoundaryPanel.DEFAULT_COLORS[i % BoundaryPanel.DEFAULT_COLORS.length]);
                }
            }
            this.m_classPanel.setColours(fastVector);
            this.m_boundaryPanel.setColors(fastVector);
        }
    }

    public void setInstancesFromFileQ() {
        int n = this.m_FileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = this.m_FileChooser.getSelectedFile();
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                Instances instances = new Instances(bufferedReader);
                this.setInstances(instances);
                this.dataFileLabel.setText(instances.relationName());
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Can't load at this time,\ncurrently busy with other IO", "Load Instances", 2);
                exception.printStackTrace();
            }
        }
    }

    public int setUpBoundaryPanel() throws Exception {
        int n = 0;
        int n2 = this.m_numberOfSamplesFromEachRegion;
        try {
            n2 = Integer.parseInt(this.m_regionSamplesText.getText().trim());
        }
        catch (Exception exception) {
            this.m_regionSamplesText.setText("" + n2);
        }
        this.m_numberOfSamplesFromEachRegion = n2;
        this.m_boundaryPanel.setNumSamplesPerRegion(n2);
        n2 = this.m_generatorSamplesBase;
        try {
            n2 = Integer.parseInt(this.m_generatorSamplesText.getText().trim());
        }
        catch (Exception exception) {
            this.m_generatorSamplesText.setText("" + n2);
        }
        this.m_generatorSamplesBase = n2;
        this.m_boundaryPanel.setGeneratorSamplesBase(n2);
        n2 = this.m_kernelBandwidth;
        try {
            n2 = Integer.parseInt(this.m_kernelBandwidthText.getText().trim());
        }
        catch (Exception exception) {
            this.m_kernelBandwidthText.setText("" + n2);
        }
        this.m_kernelBandwidth = n2;
        this.m_dataGenerator.setKernelBandwidth(n2);
        if (this.m_kernelBandwidth < 0) {
            n = 1;
        }
        if (this.m_kernelBandwidth >= this.m_trainingInstances.numInstances()) {
            n = 2;
        }
        this.m_trainingInstances.setClassIndex(this.m_classAttBox.getSelectedIndex());
        this.m_boundaryPanel.setClassifier(this.m_classifier);
        this.m_boundaryPanel.setTrainingData(this.m_trainingInstances);
        this.m_boundaryPanel.setXAttribute(this.m_xIndex);
        this.m_boundaryPanel.setYAttribute(this.m_yIndex);
        this.m_boundaryPanel.setPlotTrainingData(this.m_plotTrainingData.isSelected());
        return n;
    }

    public void plotTrainingData() throws Exception {
        this.m_boundaryPanel.initialize();
        this.setUpBoundaryPanel();
        this.computeBounds();
        this.m_boundaryPanel.plotTrainingData();
    }

    public void stopPlotting() {
        this.m_boundaryPanel.stopPlotting();
    }

    public static void setExitIfNoWindowsOpen(boolean bl) {
        m_ExitIfNoWindowsOpen = bl;
    }

    public static boolean getExitIfNoWindowsOpen() {
        return m_ExitIfNoWindowsOpen;
    }

    public static void createNewVisualizerWindow(Classifier classifier, Instances instances) throws Exception {
        ++m_WindowCount;
        final JFrame jFrame = new JFrame("Weka classification boundary visualizer");
        jFrame.getContentPane().setLayout(new BorderLayout());
        final BoundaryVisualizer boundaryVisualizer = new BoundaryVisualizer();
        jFrame.getContentPane().add((Component)boundaryVisualizer, "Center");
        jFrame.setSize(boundaryVisualizer.getMinimumSize());
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                boundaryVisualizer.stopPlotting();
                jFrame.dispose();
                if (--m_WindowCount == 0 && m_ExitIfNoWindowsOpen) {
                    System.exit(0);
                }
            }
        });
        jFrame.pack();
        jFrame.setVisible(true);
        jFrame.setResizable(false);
        Dimension dimension = jFrame.getSize();
        if (classifier == null) {
            boundaryVisualizer.setClassifier(null);
        } else {
            boundaryVisualizer.setClassifier(classifier);
            boundaryVisualizer.m_classifierEditor.setValue(classifier);
        }
        if (instances == null) {
            boundaryVisualizer.setInstances(null);
        } else {
            boundaryVisualizer.setInstances(instances);
            try {
                boundaryVisualizer.dataFileLabel.setText(instances.relationName());
                boundaryVisualizer.plotTrainingData();
                boundaryVisualizer.m_classPanel.setCindex(boundaryVisualizer.m_classAttBox.getSelectedIndex());
                boundaryVisualizer.repaint(0L, 0, 0, boundaryVisualizer.getWidth(), boundaryVisualizer.getHeight());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void main(String[] stringArray) {
        Logger.log(Logger.Level.INFO, "Logging started");
        try {
            if (stringArray.length < 2) {
                BoundaryVisualizer.createNewVisualizerWindow(null, null);
            } else {
                String[] stringArray2 = null;
                if (stringArray.length > 2) {
                    stringArray2 = new String[stringArray.length - 2];
                    for (int i = 2; i < stringArray.length; ++i) {
                        stringArray2[i - 2] = stringArray[i];
                    }
                }
                Classifier classifier = Classifier.forName(stringArray[1], stringArray2);
                System.err.println("Loading instances from : " + stringArray[0]);
                BufferedReader bufferedReader = new BufferedReader(new FileReader(stringArray[0]));
                Instances instances = new Instances(bufferedReader);
                BoundaryVisualizer.createNewVisualizerWindow(classifier, instances);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private class AxisPanel
    extends JPanel {
        private static final long serialVersionUID = -7421022416674492712L;
        private static final int MAX_PRECISION = 10;
        private boolean m_vertical = false;
        private final int PAD = 5;
        private FontMetrics m_fontMetrics;
        private int m_fontHeight;

        public AxisPanel(boolean bl) {
            this.m_vertical = bl;
            this.setBackground(Color.black);
            String string = this.getFont().getFamily();
            Font font = new Font(string, 0, 10);
            this.setFont(font);
        }

        public Dimension getPreferredSize() {
            if (this.m_fontMetrics == null) {
                Graphics graphics = this.getGraphics();
                this.m_fontMetrics = graphics.getFontMetrics();
                this.m_fontHeight = this.m_fontMetrics.getHeight();
            }
            if (!this.m_vertical) {
                return new Dimension(this.getSize().width, 7 + this.m_fontHeight);
            }
            return new Dimension(50, this.getSize().height);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            this.setBackground(Color.black);
            if (this.m_fontMetrics == null) {
                this.m_fontMetrics = graphics.getFontMetrics();
                this.m_fontHeight = this.m_fontMetrics.getHeight();
            }
            Dimension dimension = this.getSize();
            Dimension dimension2 = BoundaryVisualizer.this.m_boundaryPanel.getSize();
            graphics.setColor(Color.gray);
            int n = this.m_fontMetrics.getAscent();
            if (!this.m_vertical) {
                graphics.drawLine(dimension.width, 5, dimension.width - dimension2.width, 5);
                if (BoundaryVisualizer.this.getInstances() != null) {
                    int n2 = 1;
                    int n3 = 1;
                    int n4 = (int)Math.abs(BoundaryVisualizer.this.m_maxX);
                    double d = Math.abs(BoundaryVisualizer.this.m_maxX) - (double)n4;
                    int n5 = n4 > 0 ? (int)(Math.log(n4) / Math.log(10.0)) : 1;
                    int n6 = n2 = d > 0.0 ? (int)Math.abs(Math.log(Math.abs(BoundaryVisualizer.this.m_maxX)) / Math.log(10.0)) + 2 : 1;
                    if (n2 > 10) {
                        n2 = 1;
                    }
                    String string = Utils.doubleToString(BoundaryVisualizer.this.m_maxX, n5 + 1 + n2, n2);
                    n4 = (int)Math.abs(BoundaryVisualizer.this.m_minX);
                    d = Math.abs(BoundaryVisualizer.this.m_minX) - (double)n4;
                    n5 = n4 > 0 ? (int)(Math.log(n4) / Math.log(10.0)) : 1;
                    int n7 = n3 = d > 0.0 ? (int)Math.abs(Math.log(Math.abs(BoundaryVisualizer.this.m_minX)) / Math.log(10.0)) + 2 : 1;
                    if (n3 > 10) {
                        n3 = 1;
                    }
                    String string2 = Utils.doubleToString(BoundaryVisualizer.this.m_minX, n5 + 1 + n3, n3);
                    graphics.drawString(string2, dimension.width - dimension2.width, 5 + n + 2);
                    int n8 = this.m_fontMetrics.stringWidth(string);
                    graphics.drawString(string, dimension.width - n8, 5 + n + 2);
                }
            } else {
                graphics.drawLine(dimension.width - 5, 0, dimension.width - 5, dimension2.height);
                if (BoundaryVisualizer.this.getInstances() != null) {
                    int n9 = 1;
                    int n10 = 1;
                    int n11 = (int)Math.abs(BoundaryVisualizer.this.m_maxY);
                    double d = Math.abs(BoundaryVisualizer.this.m_maxY) - (double)n11;
                    int n12 = n11 > 0 ? (int)(Math.log(n11) / Math.log(10.0)) : 1;
                    int n13 = n9 = d > 0.0 ? (int)Math.abs(Math.log(Math.abs(BoundaryVisualizer.this.m_maxY)) / Math.log(10.0)) + 2 : 1;
                    if (n9 > 10) {
                        n9 = 1;
                    }
                    String string = Utils.doubleToString(BoundaryVisualizer.this.m_maxY, n12 + 1 + n9, n9);
                    n11 = (int)Math.abs(BoundaryVisualizer.this.m_minY);
                    d = Math.abs(BoundaryVisualizer.this.m_minY) - (double)n11;
                    n12 = n11 > 0 ? (int)(Math.log(n11) / Math.log(10.0)) : 1;
                    int n14 = n10 = d > 0.0 ? (int)Math.abs(Math.log(Math.abs(BoundaryVisualizer.this.m_minY)) / Math.log(10.0)) + 2 : 1;
                    if (n10 > 10) {
                        n10 = 1;
                    }
                    String string3 = Utils.doubleToString(BoundaryVisualizer.this.m_minY, n12 + 1 + n10, n10);
                    int n15 = this.m_fontMetrics.stringWidth(string3);
                    graphics.drawString(string3, dimension.width - 5 - n15 - 2, dimension2.height);
                    n15 = this.m_fontMetrics.stringWidth(string);
                    graphics.drawString(string, dimension.width - 5 - n15 - 2, n);
                }
            }
        }
    }
}

