/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.RevisionHandler;
import weka.core.logging.Logger;
import weka.gui.Logger;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanInstance;
import weka.gui.beans.KnowledgeFlowApp;
import weka.gui.beans.Startable;
import weka.gui.beans.xml.XMLBeans;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowRunner
implements RevisionHandler {
    protected Vector m_beans;
    protected int m_runningCount = 0;
    protected transient Logger m_log = null;
    protected transient Environment m_env;
    protected boolean m_startSequentially = false;

    public FlowRunner() {
        KnowledgeFlowApp.loadProperties();
    }

    public void setLog(Logger logger) {
        this.m_log = logger;
    }

    protected void runSequentially(TreeMap<Integer, Startable> treeMap) {
        Set<Integer> set = treeMap.keySet();
        for (Integer n : set) {
            try {
                Startable startable = treeMap.get(n);
                startable.start();
                Thread.sleep(200L);
                this.waitUntilFinished();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (this.m_log != null) {
                    this.m_log.logMessage(exception.getMessage());
                    this.m_log.logMessage("Aborting...");
                    break;
                }
                System.err.println(exception.getMessage());
                System.err.println("Aborting...");
                break;
            }
        }
    }

    protected synchronized void launchThread(final Startable startable, final int n) {
        Thread thread = new Thread(){
            private int m_num;
            {
                this.m_num = n;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        startable.start();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if (FlowRunner.this.m_log != null) {
                            FlowRunner.this.m_log.logMessage(exception.getMessage());
                        } else {
                            System.err.println(exception.getMessage());
                        }
                        Object var3_2 = null;
                        FlowRunner.this.decreaseCount();
                    }
                    Object var3_1 = null;
                    FlowRunner.this.decreaseCount();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    FlowRunner.this.decreaseCount();
                    throw throwable;
                }
            }
        };
        ++this.m_runningCount;
        thread.setPriority(1);
        thread.start();
    }

    protected synchronized void decreaseCount() {
        --this.m_runningCount;
    }

    public synchronized void stopAllFlows() {
        for (int i = 0; i < this.m_beans.size(); ++i) {
            BeanInstance beanInstance = (BeanInstance)this.m_beans.elementAt(i);
            if (!(beanInstance.getBean() instanceof BeanCommon)) continue;
            ((BeanCommon)beanInstance.getBean()).stop();
        }
    }

    public void waitUntilFinished() {
        try {
            while (this.m_runningCount > 0) {
                Thread.sleep(200L);
            }
            while (true) {
                boolean bl = false;
                for (int i = 0; i < this.m_beans.size(); ++i) {
                    BeanInstance beanInstance = (BeanInstance)this.m_beans.elementAt(i);
                    if (!(beanInstance.getBean() instanceof BeanCommon) || !((BeanCommon)beanInstance.getBean()).isBusy()) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    Thread.sleep(3000L);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            if (this.m_log != null) {
                this.m_log.logMessage("[FlowRunner] Attempting to stop all flows...");
            } else {
                System.err.println("[FlowRunner] Attempting to stop all flows...");
            }
            this.stopAllFlows();
        }
    }

    public void load(String string) throws Exception {
        if (!string.endsWith(".kf") && !string.endsWith(".kfml")) {
            throw new Exception("Can only load and run binary or xml serialized KnowledgeFlows (*.kf | *.kfml)");
        }
        if (string.endsWith(".kf")) {
            this.loadBinary(string);
        } else if (string.endsWith(".kfml")) {
            this.loadXML(string);
        }
    }

    public void loadBinary(String string) throws Exception {
        if (!string.endsWith(".kf")) {
            throw new Exception("File must be a binary flow (*.kf)");
        }
        FileInputStream fileInputStream = new FileInputStream(string);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        this.m_beans = (Vector)objectInputStream.readObject();
        objectInputStream.close();
        if (this.m_env != null) {
            String string2 = new File(string).getParent();
            if (string2 == null) {
                string2 = "./";
            }
            this.m_env.addVariable("Internal.knowledgeflow.directory", string2);
        }
    }

    public void loadXML(String string) throws Exception {
        if (!string.endsWith(".kfml")) {
            throw new Exception("File must be an XML flow (*.kfml)");
        }
        XMLBeans xMLBeans = new XMLBeans(null, null);
        Vector vector = (Vector)xMLBeans.read(new File(string));
        this.m_beans = (Vector)vector.get(0);
        if (this.m_env != null) {
            String string2 = new File(string).getParent();
            if (string2 == null) {
                string2 = "./";
            }
            this.m_env.addVariable("Internal.knowledgeflow.directory", string2);
        } else {
            System.err.println("++++++++++++ Environment variables null!!...");
        }
    }

    public Vector getFlows() {
        return this.m_beans;
    }

    public void setFlows(Vector vector) {
        this.m_beans = vector;
    }

    public void setEnvironment(Environment environment) {
        this.m_env = environment;
    }

    public Environment getEnvironment() {
        return this.m_env;
    }

    public void setStartSequentially(boolean bl) {
        this.m_startSequentially = bl;
    }

    public boolean getStartSequentially() {
        return this.m_startSequentially;
    }

    public void run() throws Exception {
        Serializable serializable;
        int n;
        if (this.m_beans == null) {
            throw new Exception("Don't seem to have any beans I can execute.");
        }
        for (n = 0; n < this.m_beans.size(); ++n) {
            serializable = (BeanInstance)this.m_beans.elementAt(n);
            if (this.m_log != null && ((BeanInstance)serializable).getBean() instanceof BeanCommon) {
                ((BeanCommon)((BeanInstance)serializable).getBean()).setLog(this.m_log);
            }
            if (!(((BeanInstance)serializable).getBean() instanceof EnvironmentHandler)) continue;
            ((EnvironmentHandler)((BeanInstance)serializable).getBean()).setEnvironment(this.m_env);
        }
        n = 1;
        if (this.m_log != null) {
            if (this.m_startSequentially) {
                this.m_log.logMessage("[FlowRunner] launching flow start points sequentially...");
            } else {
                this.m_log.logMessage("[FlowRunner] launching flow start points in parallel...");
            }
        }
        serializable = new TreeMap();
        for (int i = 0; i < this.m_beans.size(); ++i) {
            BeanInstance beanInstance = (BeanInstance)this.m_beans.elementAt(i);
            if (!(beanInstance.getBean() instanceof Startable)) continue;
            Startable startable = (Startable)beanInstance.getBean();
            if (!this.m_startSequentially) {
                if (this.m_log != null) {
                    this.m_log.logMessage("[FlowRunner] Launching flow " + n + "...");
                } else {
                    System.out.println("[FlowRunner] Launching flow " + n + "...");
                }
                this.launchThread(startable, n);
                ++n;
                continue;
            }
            boolean bl = false;
            Integer n2 = null;
            String string = startable.getClass().getName();
            if (startable instanceof BeanCommon) {
                String string2;
                string = string2 = ((BeanCommon)((Object)startable)).getCustomName();
                if (string2.indexOf(58) > 0) {
                    String string3 = string2.substring(0, string2.indexOf(58));
                    try {
                        n2 = new Integer(string3);
                        bl = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if (!bl) {
                if (((TreeMap)serializable).size() == 0) {
                    n2 = new Integer(0);
                } else {
                    int n3 = (Integer)((TreeMap)serializable).lastKey();
                    n2 = new Integer(++n3);
                }
            }
            if (this.m_log != null) {
                this.m_log.logMessage("[FlowRunner] adding start point " + string + " to the execution list (position " + n2 + ")");
            } else {
                System.out.println("[FlowRunner] adding start point " + string + " to the execution list (position " + n2 + ")");
            }
            ((TreeMap)serializable).put(n2, startable);
        }
        if (this.m_startSequentially) {
            this.runSequentially((TreeMap<Integer, Startable>)serializable);
        }
    }

    public static void main(String[] stringArray) {
        weka.core.logging.Logger.log(Logger.Level.INFO, "Logging started");
        if (stringArray.length < 1) {
            System.err.println("Usage:\n\nFlowRunner <serialized kf file> [-s]\n\n\tUse -s to launch start points sequentially (default launches in parallel).");
        } else {
            try {
                FlowRunner flowRunner = new FlowRunner();
                SimpleLogger simpleLogger = new SimpleLogger();
                String string = stringArray[0];
                if (stringArray.length == 2 && stringArray[1].equals("-s")) {
                    flowRunner.setStartSequentially(true);
                }
                Environment environment = Environment.getSystemWide();
                flowRunner.setLog(simpleLogger);
                flowRunner.setEnvironment(environment);
                flowRunner.load(string);
                flowRunner.run();
                flowRunner.waitUntilFinished();
                System.out.println("Finished all flows.");
                System.exit(1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.err.println(exception.getMessage());
            }
        }
    }

    @Override
    public String getRevision() {
        return "$Revision: 5562 $";
    }

    public static class SimpleLogger
    implements Logger {
        SimpleDateFormat m_DateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        public void logMessage(String string) {
            System.out.println(this.m_DateFormat.format(new Date()) + ": " + string);
        }

        public void statusMessage(String string) {
            System.out.println(this.m_DateFormat.format(new Date()) + ": " + string);
        }
    }
}

