/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.UpdateableClassifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class AODE
extends Classifier
implements OptionHandler,
WeightedInstancesHandler,
UpdateableClassifier,
TechnicalInformationHandler {
    static final long serialVersionUID = 9197439980415113523L;
    private double[][][] m_CondiCounts;
    private double[] m_ClassCounts;
    private double[][] m_SumForCounts;
    private int m_NumClasses;
    private int m_NumAttributes;
    private int m_NumInstances;
    private int m_ClassIndex;
    private Instances m_Instances;
    private int m_TotalAttValues;
    private int[] m_StartAttIndex;
    private int[] m_NumAttValues;
    private double[] m_Frequencies;
    private double m_SumInstances;
    private int m_Limit = 1;
    private boolean m_Debug = false;
    private boolean m_MEstimates = false;
    private int m_Weight = 1;

    public String globalInfo() {
        return "AODE achieves highly accurate classification by averaging over all of a small space of alternative naive-Bayes-like models that have weaker (and hence less detrimental) independence assumptions than naive Bayes. The resulting algorithm is computationally efficient while delivering highly accurate classification on many learning  tasks.\n\nFor more information, see\n\n" + this.getTechnicalInformation().toString() + "\n\n" + "Further papers are available at\n" + "  http://www.csse.monash.edu.au/~webb/.\n\n" + "Can use an m-estimate for smoothing base probability estimates " + "in place of the Laplace correction (via option -M).\n" + "Default frequency limit set to 1.";
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "G. Webb and J. Boughton and Z. Wang");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2005");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Not So Naive Bayes: Aggregating One-Dependence Estimators");
        technicalInformation.setValue(TechnicalInformation.Field.JOURNAL, "Machine Learning");
        technicalInformation.setValue(TechnicalInformation.Field.VOLUME, "58");
        technicalInformation.setValue(TechnicalInformation.Field.NUMBER, "1");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "5-24");
        return technicalInformation;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAll();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.setMinimumNumberInstances(0);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        int n;
        this.getCapabilities().testWithFail(instances);
        this.m_Instances = new Instances(instances);
        this.m_Instances.deleteWithMissingClass();
        this.m_SumInstances = 0.0;
        this.m_ClassIndex = instances.classIndex();
        this.m_NumInstances = this.m_Instances.numInstances();
        this.m_NumAttributes = this.m_Instances.numAttributes();
        this.m_NumClasses = this.m_Instances.numClasses();
        this.m_StartAttIndex = new int[this.m_NumAttributes];
        this.m_NumAttValues = new int[this.m_NumAttributes];
        this.m_TotalAttValues = 0;
        for (n = 0; n < this.m_NumAttributes; ++n) {
            if (n != this.m_ClassIndex) {
                this.m_StartAttIndex[n] = this.m_TotalAttValues;
                this.m_NumAttValues[n] = this.m_Instances.attribute(n).numValues();
                this.m_TotalAttValues += this.m_NumAttValues[n] + 1;
                continue;
            }
            this.m_NumAttValues[n] = this.m_NumClasses;
        }
        this.m_CondiCounts = new double[this.m_NumClasses][this.m_TotalAttValues][this.m_TotalAttValues];
        this.m_ClassCounts = new double[this.m_NumClasses];
        this.m_SumForCounts = new double[this.m_NumClasses][this.m_NumAttributes];
        this.m_Frequencies = new double[this.m_TotalAttValues];
        for (n = 0; n < this.m_NumInstances; ++n) {
            this.addToCounts(this.m_Instances.instance(n));
        }
        this.m_Instances = new Instances(this.m_Instances, 0);
    }

    public void updateClassifier(Instance instance) {
        this.addToCounts(instance);
    }

    private void addToCounts(Instance instance) {
        int n;
        if (instance.classIsMissing()) {
            return;
        }
        int n2 = (int)instance.classValue();
        double d = instance.weight();
        int n3 = n2;
        this.m_ClassCounts[n3] = this.m_ClassCounts[n3] + d;
        this.m_SumInstances += d;
        int[] nArray = new int[this.m_NumAttributes];
        for (n = 0; n < this.m_NumAttributes; ++n) {
            nArray[n] = n == this.m_ClassIndex ? -1 : (instance.isMissing(n) ? this.m_StartAttIndex[n] + this.m_NumAttValues[n] : this.m_StartAttIndex[n] + (int)instance.value(n));
        }
        for (n = 0; n < this.m_NumAttributes; ++n) {
            if (nArray[n] == -1) continue;
            int n4 = nArray[n];
            this.m_Frequencies[n4] = this.m_Frequencies[n4] + d;
            if (!instance.isMissing(n)) {
                double[] dArray = this.m_SumForCounts[n2];
                int n5 = n;
                dArray[n5] = dArray[n5] + d;
            }
            double[] dArray = this.m_CondiCounts[n2][nArray[n]];
            for (int i = 0; i < this.m_NumAttributes; ++i) {
                if (nArray[i] == -1) continue;
                int n6 = nArray[i];
                dArray[n6] = dArray[n6] + d;
            }
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        int n;
        double[] dArray = new double[this.m_NumClasses];
        int[] nArray = new int[this.m_NumAttributes];
        for (n = 0; n < this.m_NumAttributes; ++n) {
            nArray[n] = instance.isMissing(n) || n == this.m_ClassIndex ? -1 : this.m_StartAttIndex[n] + (int)instance.value(n);
        }
        for (n = 0; n < this.m_NumClasses; ++n) {
            dArray[n] = 0.0;
            double d = 0.0;
            int n2 = 0;
            double[][] dArray2 = this.m_CondiCounts[n];
            for (int i = 0; i < this.m_NumAttributes; ++i) {
                int n3;
                if (nArray[i] == -1 || this.m_Frequencies[n3 = nArray[i]] < (double)this.m_Limit) continue;
                double[] dArray3 = dArray2[n3];
                nArray[i] = -1;
                ++n2;
                double d2 = dArray3[n3];
                double d3 = this.m_Frequencies[this.m_StartAttIndex[i] + this.m_NumAttValues[i]];
                d = !this.m_MEstimates ? (d2 + 1.0) / (this.m_SumInstances - d3 + (double)(this.m_NumClasses * this.m_NumAttValues[i])) : (d2 + (double)this.m_Weight / (double)(this.m_NumClasses * this.m_NumAttValues[i])) / (this.m_SumInstances - d3 + (double)this.m_Weight);
                for (int j = 0; j < this.m_NumAttributes; ++j) {
                    if (nArray[j] == -1) continue;
                    double d4 = dArray3[this.m_StartAttIndex[j] + this.m_NumAttValues[j]];
                    if (!this.m_MEstimates) {
                        d *= (dArray3[nArray[j]] + 1.0) / (d2 - d4 + (double)this.m_NumAttValues[j]);
                        continue;
                    }
                    d *= (dArray3[nArray[j]] + (double)this.m_Weight / (double)this.m_NumAttValues[j]) / (d2 - d4 + (double)this.m_Weight);
                }
                int n4 = n;
                dArray[n4] = dArray[n4] + d;
                nArray[i] = n3;
            }
            if (n2 < 1) {
                dArray[n] = this.NBconditionalProb(instance, n);
                continue;
            }
            int n5 = n;
            dArray[n5] = dArray[n5] / (double)n2;
        }
        Utils.normalize(dArray);
        return dArray;
    }

    public double NBconditionalProb(Instance instance, int n) {
        double d = !this.m_MEstimates ? (this.m_ClassCounts[n] + 1.0) / (this.m_SumInstances + (double)this.m_NumClasses) : (this.m_ClassCounts[n] + (double)this.m_Weight / (double)this.m_NumClasses) / (this.m_SumInstances + (double)this.m_Weight);
        double[][] dArray = this.m_CondiCounts[n];
        for (int i = 0; i < this.m_NumAttributes; ++i) {
            if (i == this.m_ClassIndex || instance.isMissing(i)) continue;
            int n2 = this.m_StartAttIndex[i] + (int)instance.value(i);
            if (!this.m_MEstimates) {
                d *= (dArray[n2][n2] + 1.0) / (this.m_SumForCounts[n][i] + (double)this.m_NumAttValues[i]);
                continue;
            }
            d *= (dArray[n2][n2] + (double)this.m_Weight / (double)this.m_NumAttValues[i]) / (this.m_SumForCounts[n][i] + (double)this.m_Weight);
        }
        return d;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(4);
        vector.addElement(new Option("\tOutput debugging information\n", "D", 0, "-D"));
        vector.addElement(new Option("\tImpose a frequency limit for superParents\n\t(default is 1)", "F", 1, "-F <int>"));
        vector.addElement(new Option("\tUse m-estimate instead of laplace correction\n", "M", 0, "-M"));
        vector.addElement(new Option("\tSpecify a weight to use with m-estimate\n\t(default is 1)", "W", 1, "-W <int>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.m_Debug = Utils.getFlag('D', stringArray);
        String string = Utils.getOption('F', stringArray);
        this.m_Limit = string.length() != 0 ? Integer.parseInt(string) : 1;
        this.m_MEstimates = Utils.getFlag('M', stringArray);
        String string2 = Utils.getOption('W', stringArray);
        if (string2.length() != 0) {
            if (!this.m_MEstimates) {
                throw new Exception("Can't use Laplace AND m-estimate weight. Choose one.");
            }
            this.m_Weight = Integer.parseInt(string2);
        } else if (this.m_MEstimates) {
            this.m_Weight = 1;
        }
        Utils.checkForRemainingOptions(stringArray);
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        if (this.m_Debug) {
            vector.add("-D");
        }
        vector.add("-F");
        vector.add("" + this.m_Limit);
        if (this.m_MEstimates) {
            vector.add("-M");
            vector.add("-W");
            vector.add("" + this.m_Weight);
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String weightTipText() {
        return "Set the weight for m-estimate.";
    }

    public void setWeight(int n) {
        if (!this.getUseMEstimates()) {
            System.out.println("Weight is only used in conjunction with m-estimate - ignored!");
        } else if (n > 0) {
            this.m_Weight = n;
        } else {
            System.out.println("Weight must be greater than 0!");
        }
    }

    public int getWeight() {
        return this.m_Weight;
    }

    public String useMEstimatesTipText() {
        return "Use m-estimate instead of laplace correction.";
    }

    public boolean getUseMEstimates() {
        return this.m_MEstimates;
    }

    public void setUseMEstimates(boolean bl) {
        this.m_MEstimates = bl;
    }

    public String frequencyLimitTipText() {
        return "Attributes with a frequency in the train set below this value aren't used as parents.";
    }

    public void setFrequencyLimit(int n) {
        this.m_Limit = n;
    }

    public int getFrequencyLimit() {
        return this.m_Limit;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("The AODE Classifier");
        if (this.m_Instances == null) {
            stringBuffer.append(": No model built yet.");
        } else {
            try {
                for (int i = 0; i < this.m_NumClasses; ++i) {
                    stringBuffer.append("\nClass " + this.m_Instances.classAttribute().value(i) + ": Prior probability = " + Utils.doubleToString((this.m_ClassCounts[i] + 1.0) / (this.m_SumInstances + (double)this.m_NumClasses), 4, 2) + "\n\n");
                }
                stringBuffer.append("Dataset: " + this.m_Instances.relationName() + "\n" + "Instances: " + this.m_NumInstances + "\n" + "Attributes: " + this.m_NumAttributes + "\n" + "Frequency limit for superParents: " + this.m_Limit + "\n");
                stringBuffer.append("Correction: ");
                if (!this.m_MEstimates) {
                    stringBuffer.append("laplace\n");
                } else {
                    stringBuffer.append("m-estimate (m=" + this.m_Weight + ")\n");
                }
            }
            catch (Exception exception) {
                stringBuffer.append(exception.getMessage());
            }
        }
        return stringBuffer.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5516 $");
    }

    public static void main(String[] stringArray) {
        AODE.runClassifier(new AODE(), stringArray);
    }
}

