/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.RevisionUtils;
import weka.core.neighboursearch.PerformanceStats;

public class TreePerformanceStats
extends PerformanceStats {
    private static final long serialVersionUID = -6637636693340810373L;
    protected int m_MinLeaves;
    protected int m_MaxLeaves;
    protected int m_SumLeaves;
    protected int m_SumSqLeaves;
    protected int m_LeafCount;
    protected int m_MinIntNodes;
    protected int m_MaxIntNodes;
    protected int m_SumIntNodes;
    protected int m_SumSqIntNodes;
    protected int m_IntNodeCount;

    public TreePerformanceStats() {
        this.reset();
    }

    public void reset() {
        super.reset();
        this.m_LeafCount = 0;
        this.m_SumSqLeaves = 0;
        this.m_SumLeaves = 0;
        this.m_MinLeaves = Integer.MAX_VALUE;
        this.m_MaxLeaves = Integer.MIN_VALUE;
        this.m_IntNodeCount = 0;
        this.m_SumSqIntNodes = 0;
        this.m_SumIntNodes = 0;
        this.m_MinIntNodes = Integer.MAX_VALUE;
        this.m_MaxIntNodes = Integer.MIN_VALUE;
    }

    public void searchStart() {
        super.searchStart();
        this.m_LeafCount = 0;
        this.m_IntNodeCount = 0;
    }

    public void searchFinish() {
        super.searchFinish();
        this.m_SumLeaves += this.m_LeafCount;
        this.m_SumSqLeaves += this.m_LeafCount * this.m_LeafCount;
        if (this.m_LeafCount < this.m_MinLeaves) {
            this.m_MinLeaves = this.m_LeafCount;
        }
        if (this.m_LeafCount > this.m_MaxLeaves) {
            this.m_MaxLeaves = this.m_LeafCount;
        }
        this.m_SumIntNodes += this.m_IntNodeCount;
        this.m_SumSqIntNodes += this.m_IntNodeCount * this.m_IntNodeCount;
        if (this.m_IntNodeCount < this.m_MinIntNodes) {
            this.m_MinIntNodes = this.m_IntNodeCount;
        }
        if (this.m_IntNodeCount > this.m_MaxIntNodes) {
            this.m_MaxIntNodes = this.m_IntNodeCount;
        }
    }

    public void incrLeafCount() {
        ++this.m_LeafCount;
    }

    public void incrIntNodeCount() {
        ++this.m_IntNodeCount;
    }

    public int getTotalLeavesVisited() {
        return this.m_SumLeaves;
    }

    public double getMeanLeavesVisited() {
        return (double)this.m_SumLeaves / (double)this.m_NumQueries;
    }

    public double getStdDevLeavesVisited() {
        return Math.sqrt(((double)this.m_SumSqLeaves - (double)(this.m_SumLeaves * this.m_SumLeaves) / (double)this.m_NumQueries) / (double)(this.m_NumQueries - 1));
    }

    public int getMinLeavesVisited() {
        return this.m_MinLeaves;
    }

    public int getMaxLeavesVisited() {
        return this.m_MaxLeaves;
    }

    public int getTotalIntNodesVisited() {
        return this.m_SumIntNodes;
    }

    public double getMeanIntNodesVisited() {
        return (double)this.m_SumIntNodes / (double)this.m_NumQueries;
    }

    public double getStdDevIntNodesVisited() {
        return Math.sqrt(((double)this.m_SumSqIntNodes - (double)(this.m_SumIntNodes * this.m_SumIntNodes) / (double)this.m_NumQueries) / (double)(this.m_NumQueries - 1));
    }

    public int getMinIntNodesVisited() {
        return this.m_MinIntNodes;
    }

    public int getMaxIntNodesVisited() {
        return this.m_MaxIntNodes;
    }

    public Enumeration enumerateMeasures() {
        Vector vector = new Vector();
        Enumeration enumeration = super.enumerateMeasures();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        vector.addElement("measureTotal_nodes_visited");
        vector.addElement("measureMean_nodes_visited");
        vector.addElement("measureStdDev_nodes_visited");
        vector.addElement("measureMin_nodes_visited");
        vector.addElement("measureMax_nodes_visited");
        vector.addElement("measureTotal_leaves_visited");
        vector.addElement("measureMean_leaves_visited");
        vector.addElement("measureStdDev_leaves_visited");
        vector.addElement("measureMin_leaves_visited");
        vector.addElement("measureMax_leaves_visited");
        return vector.elements();
    }

    public double getMeasure(String string) throws IllegalArgumentException {
        if (string.compareToIgnoreCase("measureTotal_nodes_visited") == 0) {
            return this.getTotalIntNodesVisited();
        }
        if (string.compareToIgnoreCase("measureMean_nodes_visited") == 0) {
            return this.getMeanIntNodesVisited();
        }
        if (string.compareToIgnoreCase("measureStdDev_nodes_visited") == 0) {
            return this.getStdDevIntNodesVisited();
        }
        if (string.compareToIgnoreCase("measureMin_nodes_visited") == 0) {
            return this.getMinIntNodesVisited();
        }
        if (string.compareToIgnoreCase("measureMax_nodes_visited") == 0) {
            return this.getMaxIntNodesVisited();
        }
        if (string.compareToIgnoreCase("measureTotal_leaves_visited") == 0) {
            return this.getTotalLeavesVisited();
        }
        if (string.compareToIgnoreCase("measureMean_leaves_visited") == 0) {
            return this.getMeanLeavesVisited();
        }
        if (string.compareToIgnoreCase("measureStdDev_leaves_visited") == 0) {
            return this.getStdDevLeavesVisited();
        }
        if (string.compareToIgnoreCase("measureMin_leaves_visited") == 0) {
            return this.getMinLeavesVisited();
        }
        if (string.compareToIgnoreCase("measureMax_leaves_visited") == 0) {
            return this.getMaxLeavesVisited();
        }
        return super.getMeasure(string);
    }

    public String getStats() {
        StringBuffer stringBuffer = new StringBuffer(super.getStats());
        stringBuffer.append("leaves:    " + this.getMinLeavesVisited() + ", " + this.getMaxLeavesVisited() + "," + this.getTotalLeavesVisited() + "," + this.getMeanLeavesVisited() + ", " + this.getStdDevLeavesVisited() + "\n");
        stringBuffer.append("Int nodes: " + this.getMinIntNodesVisited() + ", " + this.getMaxIntNodesVisited() + "," + this.getTotalIntNodesVisited() + "," + this.getMeanIntNodesVisited() + ", " + this.getStdDevIntNodesVisited() + "\n");
        return stringBuffer.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }
}

