/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.mi;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.functions.Logistic;
import weka.classifiers.functions.supportVector.Kernel;
import weka.classifiers.functions.supportVector.SMOset;
import weka.classifiers.mi.SimpleMI;
import weka.classifiers.mi.supportVector.MIPolyKernel;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.Option;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.SerializedObject;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.MultiInstanceToPropositional;
import weka.filters.unsupervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.Normalize;
import weka.filters.unsupervised.attribute.PropositionalToMultiInstance;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;
import weka.filters.unsupervised.attribute.Standardize;

public class MISMO
extends Classifier
implements WeightedInstancesHandler,
MultiInstanceCapabilitiesHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -5834036950143719712L;
    public static final int FILTER_NORMALIZE = 0;
    public static final int FILTER_STANDARDIZE = 1;
    public static final int FILTER_NONE = 2;
    public static final Tag[] TAGS_FILTER = new Tag[]{new Tag(0, "Normalize training data"), new Tag(1, "Standardize training data"), new Tag(2, "No normalization/standardization")};
    protected BinaryMISMO[][] m_classifiers = null;
    protected double m_C = 1.0;
    protected double m_eps = 1.0E-12;
    protected double m_tol = 0.001;
    protected int m_filterType = 0;
    protected boolean m_minimax = false;
    protected NominalToBinary m_NominalToBinary;
    protected Filter m_Filter = null;
    protected ReplaceMissingValues m_Missing;
    protected int m_classIndex = -1;
    protected Attribute m_classAttribute;
    protected Kernel m_kernel = new MIPolyKernel();
    protected boolean m_checksTurnedOff;
    protected static double m_Del = 4.94E-321;
    protected boolean m_fitLogisticModels = false;
    protected int m_numFolds = -1;
    protected int m_randomSeed = 1;

    public String globalInfo() {
        return "Implements John Platt's sequential minimal optimization algorithm for training a support vector classifier.\n\nThis implementation globally replaces all missing values and transforms nominal attributes into binary ones. It also normalizes all attributes by default. (In that case the coefficients in the output are based on the normalized data, not the original data --- this is important for interpreting the classifier.)\n\nMulti-class problems are solved using pairwise classification.\n\nTo obtain proper probability estimates, use the option that fits logistic regression models to the outputs of the support vector machine. In the multi-class case the predicted probabilities are coupled using Hastie and Tibshirani's pairwise coupling method.\n\nNote: for improved speed normalization should be turned off when operating on SparseInstances.\n\nFor more information on the SMO algorithm, see\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INCOLLECTION);
        result.setValue(TechnicalInformation.Field.AUTHOR, "J. Platt");
        result.setValue(TechnicalInformation.Field.YEAR, "1998");
        result.setValue(TechnicalInformation.Field.TITLE, "Machines using Sequential Minimal Optimization");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Advances in Kernel Methods - Support Vector Learning");
        result.setValue(TechnicalInformation.Field.EDITOR, "B. Schoelkopf and C. Burges and A. Smola");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "MIT Press");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.ARTICLE);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "S.S. Keerthi and S.K. Shevade and C. Bhattacharyya and K.R.K. Murthy");
        additional.setValue(TechnicalInformation.Field.YEAR, "2001");
        additional.setValue(TechnicalInformation.Field.TITLE, "Improvements to Platt's SMO Algorithm for SVM Classifier Design");
        additional.setValue(TechnicalInformation.Field.JOURNAL, "Neural Computation");
        additional.setValue(TechnicalInformation.Field.VOLUME, "13");
        additional.setValue(TechnicalInformation.Field.NUMBER, "3");
        additional.setValue(TechnicalInformation.Field.PAGES, "637-649");
        return result;
    }

    public void turnChecksOff() {
        this.m_checksTurnedOff = true;
    }

    public void turnChecksOn() {
        this.m_checksTurnedOff = false;
    }

    public Capabilities getCapabilities() {
        Capabilities result = this.getKernel().getCapabilities();
        result.setOwner(this);
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.disableAllClasses();
        result.disableAllClassDependencies();
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.ONLY_MULTIINSTANCE);
        return result;
    }

    public Capabilities getMultiInstanceCapabilities() {
        Capabilities result = ((MultiInstanceCapabilitiesHandler)((Object)this.getKernel())).getMultiInstanceCapabilities();
        result.setOwner(this);
        result.enableAllAttributeDependencies();
        if (result.handles(Capabilities.Capability.NUMERIC_ATTRIBUTES)) {
            result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        }
        result.enable(Capabilities.Capability.MISSING_VALUES);
        return result;
    }

    public void buildClassifier(Instances insts) throws Exception {
        int i;
        Instances transformedInsts;
        int i2;
        if (!this.m_checksTurnedOff) {
            this.getCapabilities().testWithFail(insts);
            insts = new Instances(insts);
            insts.deleteWithMissingClass();
            Instances data = new Instances(insts, insts.numInstances());
            for (i2 = 0; i2 < insts.numInstances(); ++i2) {
                if (!(insts.instance(i2).weight() > 0.0)) continue;
                data.add(insts.instance(i2));
            }
            if (data.numInstances() == 0) {
                throw new Exception("No training instances left after removing instance with either a weight null or a missing class!");
            }
            insts = data;
        }
        this.m_Missing = !this.m_checksTurnedOff ? new ReplaceMissingValues() : null;
        if (this.getCapabilities().handles(Capabilities.Capability.NUMERIC_ATTRIBUTES)) {
            boolean onlyNumeric = true;
            if (!this.m_checksTurnedOff) {
                for (i2 = 0; i2 < insts.numAttributes(); ++i2) {
                    if (i2 == insts.classIndex() || insts.attribute(i2).isNumeric()) continue;
                    onlyNumeric = false;
                    break;
                }
            }
            if (!onlyNumeric) {
                this.m_NominalToBinary = new NominalToBinary();
                this.m_NominalToBinary.setAttributeIndices("2-last");
            } else {
                this.m_NominalToBinary = null;
            }
        } else {
            this.m_NominalToBinary = null;
        }
        this.m_Filter = this.m_filterType == 1 ? new Standardize() : (this.m_filterType == 0 ? new Normalize() : null);
        MultiInstanceToPropositional convertToProp = new MultiInstanceToPropositional();
        PropositionalToMultiInstance convertToMI = new PropositionalToMultiInstance();
        if (this.m_minimax) {
            SimpleMI transMinimax = new SimpleMI();
            transMinimax.setTransformMethod(new SelectedTag(3, SimpleMI.TAGS_TRANSFORMMETHOD));
            transformedInsts = transMinimax.transform(insts);
        } else {
            ((Filter)convertToProp).setInputFormat(insts);
            transformedInsts = Filter.useFilter(insts, convertToProp);
        }
        if (this.m_Missing != null) {
            this.m_Missing.setInputFormat(transformedInsts);
            transformedInsts = Filter.useFilter(transformedInsts, this.m_Missing);
        }
        if (this.m_NominalToBinary != null) {
            this.m_NominalToBinary.setInputFormat(transformedInsts);
            transformedInsts = Filter.useFilter(transformedInsts, this.m_NominalToBinary);
        }
        if (this.m_Filter != null) {
            this.m_Filter.setInputFormat(transformedInsts);
            transformedInsts = Filter.useFilter(transformedInsts, this.m_Filter);
        }
        ((Filter)convertToMI).setInputFormat(transformedInsts);
        insts = Filter.useFilter(transformedInsts, convertToMI);
        this.m_classIndex = insts.classIndex();
        this.m_classAttribute = insts.classAttribute();
        Instances[] subsets = new Instances[insts.numClasses()];
        for (i = 0; i < insts.numClasses(); ++i) {
            subsets[i] = new Instances(insts, insts.numInstances());
        }
        for (int j = 0; j < insts.numInstances(); ++j) {
            Instance inst = insts.instance(j);
            subsets[(int)inst.classValue()].add(inst);
        }
        for (i = 0; i < insts.numClasses(); ++i) {
            subsets[i].compactify();
        }
        Random rand = new Random(this.m_randomSeed);
        this.m_classifiers = new BinaryMISMO[insts.numClasses()][insts.numClasses()];
        for (int i3 = 0; i3 < insts.numClasses(); ++i3) {
            for (int j = i3 + 1; j < insts.numClasses(); ++j) {
                int k;
                this.m_classifiers[i3][j] = new BinaryMISMO();
                this.m_classifiers[i3][j].setKernel(Kernel.makeCopy(this.getKernel()));
                Instances data = new Instances(insts, insts.numInstances());
                for (k = 0; k < subsets[i3].numInstances(); ++k) {
                    data.add(subsets[i3].instance(k));
                }
                for (k = 0; k < subsets[j].numInstances(); ++k) {
                    data.add(subsets[j].instance(k));
                }
                data.compactify();
                data.randomize(rand);
                this.m_classifiers[i3][j].buildClassifier(data, i3, j, this.m_fitLogisticModels, this.m_numFolds, this.m_randomSeed);
            }
        }
    }

    public double[] distributionForInstance(Instance inst) throws Exception {
        Instances insts = new Instances(inst.dataset(), 0);
        insts.add(inst);
        MultiInstanceToPropositional convertToProp = new MultiInstanceToPropositional();
        PropositionalToMultiInstance convertToMI = new PropositionalToMultiInstance();
        if (this.m_minimax) {
            SimpleMI transMinimax = new SimpleMI();
            transMinimax.setTransformMethod(new SelectedTag(3, SimpleMI.TAGS_TRANSFORMMETHOD));
            insts = transMinimax.transform(insts);
        } else {
            ((Filter)convertToProp).setInputFormat(insts);
            insts = Filter.useFilter(insts, convertToProp);
        }
        if (this.m_Missing != null) {
            insts = Filter.useFilter(insts, this.m_Missing);
        }
        if (this.m_Filter != null) {
            insts = Filter.useFilter(insts, this.m_Filter);
        }
        ((Filter)convertToMI).setInputFormat(insts);
        insts = Filter.useFilter(insts, convertToMI);
        inst = insts.instance(0);
        if (!this.m_fitLogisticModels) {
            double[] result = new double[inst.numClasses()];
            for (int i = 0; i < inst.numClasses(); ++i) {
                for (int j = i + 1; j < inst.numClasses(); ++j) {
                    if (this.m_classifiers[i][j].m_alpha == null && this.m_classifiers[i][j].m_sparseWeights == null) continue;
                    double output = this.m_classifiers[i][j].SVMOutput(-1, inst);
                    if (output > 0.0) {
                        int n = j;
                        result[n] = result[n] + 1.0;
                        continue;
                    }
                    int n = i;
                    result[n] = result[n] + 1.0;
                }
            }
            Utils.normalize(result);
            return result;
        }
        if (inst.numClasses() == 2) {
            double[] newInst = new double[]{this.m_classifiers[0][1].SVMOutput(-1, inst), Instance.missingValue()};
            return this.m_classifiers[0][1].m_logistic.distributionForInstance(new Instance(1.0, newInst));
        }
        double[][] r = new double[inst.numClasses()][inst.numClasses()];
        double[][] n = new double[inst.numClasses()][inst.numClasses()];
        for (int i = 0; i < inst.numClasses(); ++i) {
            for (int j = i + 1; j < inst.numClasses(); ++j) {
                if (this.m_classifiers[i][j].m_alpha == null && this.m_classifiers[i][j].m_sparseWeights == null) continue;
                double[] newInst = new double[]{this.m_classifiers[i][j].SVMOutput(-1, inst), Instance.missingValue()};
                r[i][j] = this.m_classifiers[i][j].m_logistic.distributionForInstance(new Instance(1.0, newInst))[0];
                n[i][j] = this.m_classifiers[i][j].m_sumOfWeights;
            }
        }
        return this.pairwiseCoupling(n, r);
    }

    public double[] pairwiseCoupling(double[][] n, double[][] r) {
        boolean changed;
        double[] p = new double[r.length];
        for (int i = 0; i < p.length; ++i) {
            p[i] = 1.0 / (double)p.length;
        }
        double[][] u = new double[r.length][r.length];
        for (int i = 0; i < r.length; ++i) {
            for (int j = i + 1; j < r.length; ++j) {
                u[i][j] = 0.5;
            }
        }
        double[] firstSum = new double[p.length];
        for (int i = 0; i < p.length; ++i) {
            for (int j = i + 1; j < p.length; ++j) {
                int n2 = i;
                firstSum[n2] = firstSum[n2] + n[i][j] * r[i][j];
                int n3 = j;
                firstSum[n3] = firstSum[n3] + n[i][j] * (1.0 - r[i][j]);
            }
        }
        do {
            int i;
            changed = false;
            double[] secondSum = new double[p.length];
            for (i = 0; i < p.length; ++i) {
                for (int j = i + 1; j < p.length; ++j) {
                    int n4 = i;
                    secondSum[n4] = secondSum[n4] + n[i][j] * u[i][j];
                    int n5 = j;
                    secondSum[n5] = secondSum[n5] + n[i][j] * (1.0 - u[i][j]);
                }
            }
            for (i = 0; i < p.length; ++i) {
                if (firstSum[i] == 0.0 || secondSum[i] == 0.0) {
                    if (p[i] > 0.0) {
                        changed = true;
                    }
                    p[i] = 0.0;
                    continue;
                }
                double factor = firstSum[i] / secondSum[i];
                double pOld = p[i];
                int n6 = i;
                p[n6] = p[n6] * factor;
                if (!(Math.abs(pOld - p[i]) > 0.001)) continue;
                changed = true;
            }
            Utils.normalize(p);
            for (i = 0; i < r.length; ++i) {
                for (int j = i + 1; j < r.length; ++j) {
                    u[i][j] = p[i] / (p[i] + p[j]);
                }
            }
        } while (changed);
        return p;
    }

    public double[][][] sparseWeights() {
        int numValues = this.m_classAttribute.numValues();
        double[][][] sparseWeights = new double[numValues][numValues][];
        for (int i = 0; i < numValues; ++i) {
            for (int j = i + 1; j < numValues; ++j) {
                sparseWeights[i][j] = this.m_classifiers[i][j].m_sparseWeights;
            }
        }
        return sparseWeights;
    }

    public int[][][] sparseIndices() {
        int numValues = this.m_classAttribute.numValues();
        int[][][] sparseIndices = new int[numValues][numValues][];
        for (int i = 0; i < numValues; ++i) {
            for (int j = i + 1; j < numValues; ++j) {
                sparseIndices[i][j] = this.m_classifiers[i][j].m_sparseIndices;
            }
        }
        return sparseIndices;
    }

    public double[][] bias() {
        int numValues = this.m_classAttribute.numValues();
        double[][] bias = new double[numValues][numValues];
        for (int i = 0; i < numValues; ++i) {
            for (int j = i + 1; j < numValues; ++j) {
                bias[i][j] = this.m_classifiers[i][j].m_b;
            }
        }
        return bias;
    }

    public int numClassAttributeValues() {
        return this.m_classAttribute.numValues();
    }

    public String[] classAttributeNames() {
        int numValues = this.m_classAttribute.numValues();
        String[] classAttributeNames = new String[numValues];
        for (int i = 0; i < numValues; ++i) {
            classAttributeNames[i] = this.m_classAttribute.value(i);
        }
        return classAttributeNames;
    }

    public String[][][] attributeNames() {
        int numValues = this.m_classAttribute.numValues();
        String[][][] attributeNames = new String[numValues][numValues][];
        for (int i = 0; i < numValues; ++i) {
            for (int j = i + 1; j < numValues; ++j) {
                int numAttributes = this.m_classifiers[i][j].m_data.numAttributes();
                String[] attrNames = new String[numAttributes];
                for (int k = 0; k < numAttributes; ++k) {
                    attrNames[k] = this.m_classifiers[i][j].m_data.attribute(k).name();
                }
                attributeNames[i][j] = attrNames;
            }
        }
        return attributeNames;
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.addElement(enm.nextElement());
        }
        result.addElement(new Option("\tTurns off all checks - use with caution!\n\tTurning them off assumes that data is purely numeric, doesn't\n\tcontain any missing values, and has a nominal class. Turning them\n\toff also means that no header information will be stored if the\n\tmachine is linear. Finally, it also assumes that no instance has\n\ta weight equal to 0.\n\t(default: checks on)", "no-checks", 0, "-no-checks"));
        result.addElement(new Option("\tThe complexity constant C. (default 1)", "C", 1, "-C <double>"));
        result.addElement(new Option("\tWhether to 0=normalize/1=standardize/2=neither.\n\t(default 0=normalize)", "N", 1, "-N"));
        result.addElement(new Option("\tUse MIminimax feature space. ", "I", 0, "-I"));
        result.addElement(new Option("\tThe tolerance parameter. (default 1.0e-3)", "L", 1, "-L <double>"));
        result.addElement(new Option("\tThe epsilon for round-off error. (default 1.0e-12)", "P", 1, "-P <double>"));
        result.addElement(new Option("\tFit logistic models to SVM outputs. ", "M", 0, "-M"));
        result.addElement(new Option("\tThe number of folds for the internal cross-validation. \n\t(default -1, use training data)", "V", 1, "-V <double>"));
        result.addElement(new Option("\tThe random number seed. (default 1)", "W", 1, "-W <double>"));
        result.addElement(new Option("\tThe Kernel to use.\n\t(default: weka.classifiers.functions.supportVector.PolyKernel)", "K", 1, "-K <classname and parameters>"));
        result.addElement(new Option("", "", 0, "\nOptions specific to kernel " + this.getKernel().getClass().getName() + ":"));
        enm = this.getKernel().listOptions();
        while (enm.hasMoreElements()) {
            result.addElement(enm.nextElement());
        }
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.setChecksTurnedOff(Utils.getFlag("no-checks", options));
        String tmpStr = Utils.getOption('C', options);
        if (tmpStr.length() != 0) {
            this.setC(Double.parseDouble(tmpStr));
        } else {
            this.setC(1.0);
        }
        tmpStr = Utils.getOption('L', options);
        if (tmpStr.length() != 0) {
            this.setToleranceParameter(Double.parseDouble(tmpStr));
        } else {
            this.setToleranceParameter(0.001);
        }
        tmpStr = Utils.getOption('P', options);
        if (tmpStr.length() != 0) {
            this.setEpsilon(new Double(tmpStr));
        } else {
            this.setEpsilon(1.0E-12);
        }
        this.setMinimax(Utils.getFlag('I', options));
        tmpStr = Utils.getOption('N', options);
        if (tmpStr.length() != 0) {
            this.setFilterType(new SelectedTag(Integer.parseInt(tmpStr), TAGS_FILTER));
        } else {
            this.setFilterType(new SelectedTag(0, TAGS_FILTER));
        }
        this.setBuildLogisticModels(Utils.getFlag('M', options));
        tmpStr = Utils.getOption('V', options);
        this.m_numFolds = tmpStr.length() != 0 ? Integer.parseInt(tmpStr) : -1;
        tmpStr = Utils.getOption('W', options);
        if (tmpStr.length() != 0) {
            this.setRandomSeed(Integer.parseInt(tmpStr));
        } else {
            this.setRandomSeed(1);
        }
        tmpStr = Utils.getOption('K', options);
        String[] tmpOptions = Utils.splitOptions(tmpStr);
        if (tmpOptions.length != 0) {
            tmpStr = tmpOptions[0];
            tmpOptions[0] = "";
            this.setKernel(Kernel.forName(tmpStr, tmpOptions));
        }
        super.setOptions(options);
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        if (this.getChecksTurnedOff()) {
            result.add("-no-checks");
        }
        result.add("-C");
        result.add("" + this.getC());
        result.add("-L");
        result.add("" + this.getToleranceParameter());
        result.add("-P");
        result.add("" + this.getEpsilon());
        result.add("-N");
        result.add("" + this.m_filterType);
        if (this.getMinimax()) {
            result.add("-I");
        }
        if (this.getBuildLogisticModels()) {
            result.add("-M");
        }
        result.add("-V");
        result.add("" + this.getNumFolds());
        result.add("-W");
        result.add("" + this.getRandomSeed());
        result.add("-K");
        result.add("" + this.getKernel().getClass().getName() + " " + Utils.joinOptions(this.getKernel().getOptions()));
        return result.toArray(new String[result.size()]);
    }

    public void setChecksTurnedOff(boolean value) {
        if (value) {
            this.turnChecksOff();
        } else {
            this.turnChecksOn();
        }
    }

    public boolean getChecksTurnedOff() {
        return this.m_checksTurnedOff;
    }

    public String checksTurnedOffTipText() {
        return "Turns time-consuming checks off - use with caution.";
    }

    public String kernelTipText() {
        return "The kernel to use.";
    }

    public Kernel getKernel() {
        return this.m_kernel;
    }

    public void setKernel(Kernel value) {
        if (!(value instanceof MultiInstanceCapabilitiesHandler)) {
            throw new IllegalArgumentException("Kernel must be able to handle multi-instance data!\n(This one does not implement " + MultiInstanceCapabilitiesHandler.class.getName() + ")");
        }
        this.m_kernel = value;
    }

    public String cTipText() {
        return "The complexity parameter C.";
    }

    public double getC() {
        return this.m_C;
    }

    public void setC(double v) {
        this.m_C = v;
    }

    public String toleranceParameterTipText() {
        return "The tolerance parameter (shouldn't be changed).";
    }

    public double getToleranceParameter() {
        return this.m_tol;
    }

    public void setToleranceParameter(double v) {
        this.m_tol = v;
    }

    public String epsilonTipText() {
        return "The epsilon for round-off error (shouldn't be changed).";
    }

    public double getEpsilon() {
        return this.m_eps;
    }

    public void setEpsilon(double v) {
        this.m_eps = v;
    }

    public String filterTypeTipText() {
        return "Determines how/if the data will be transformed.";
    }

    public SelectedTag getFilterType() {
        return new SelectedTag(this.m_filterType, TAGS_FILTER);
    }

    public void setFilterType(SelectedTag newType) {
        if (newType.getTags() == TAGS_FILTER) {
            this.m_filterType = newType.getSelectedTag().getID();
        }
    }

    public String minimaxTipText() {
        return "Whether the MIMinimax feature space is to be used.";
    }

    public boolean getMinimax() {
        return this.m_minimax;
    }

    public void setMinimax(boolean v) {
        this.m_minimax = v;
    }

    public String buildLogisticModelsTipText() {
        return "Whether to fit logistic models to the outputs (for proper probability estimates).";
    }

    public boolean getBuildLogisticModels() {
        return this.m_fitLogisticModels;
    }

    public void setBuildLogisticModels(boolean newbuildLogisticModels) {
        this.m_fitLogisticModels = newbuildLogisticModels;
    }

    public String numFoldsTipText() {
        return "The number of folds for cross-validation used to generate training data for logistic models (-1 means use training data).";
    }

    public int getNumFolds() {
        return this.m_numFolds;
    }

    public void setNumFolds(int newnumFolds) {
        this.m_numFolds = newnumFolds;
    }

    public String randomSeedTipText() {
        return "Random number seed for the cross-validation.";
    }

    public int getRandomSeed() {
        return this.m_randomSeed;
    }

    public void setRandomSeed(int newrandomSeed) {
        this.m_randomSeed = newrandomSeed;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        if (this.m_classAttribute == null) {
            return "SMO: No model built yet.";
        }
        try {
            text.append("SMO\n\n");
            for (int i = 0; i < this.m_classAttribute.numValues(); ++i) {
                for (int j = i + 1; j < this.m_classAttribute.numValues(); ++j) {
                    text.append("Classifier for classes: " + this.m_classAttribute.value(i) + ", " + this.m_classAttribute.value(j) + "\n\n");
                    text.append(this.m_classifiers[i][j]);
                    if (this.m_fitLogisticModels) {
                        text.append("\n\n");
                        if (this.m_classifiers[i][j].m_logistic == null) {
                            text.append("No logistic model has been fit.\n");
                        } else {
                            text.append(this.m_classifiers[i][j].m_logistic);
                        }
                    }
                    text.append("\n\n");
                }
            }
        }
        catch (Exception e) {
            return "Can't print SMO classifier.";
        }
        return text.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.6 $");
    }

    public static void main(String[] argv) {
        MISMO.runClassifier(new MISMO(), argv);
    }

    protected class BinaryMISMO
    implements Serializable,
    RevisionHandler {
        static final long serialVersionUID = -7107082483475433531L;
        protected double[] m_alpha;
        protected double m_b;
        protected double m_bLow;
        protected double m_bUp;
        protected int m_iLow;
        protected int m_iUp;
        protected Instances m_data;
        protected double[] m_weights;
        protected double[] m_sparseWeights;
        protected int[] m_sparseIndices;
        protected Kernel m_kernel;
        protected double[] m_class;
        protected double[] m_errors;
        protected SMOset m_I0;
        protected SMOset m_I1;
        protected SMOset m_I2;
        protected SMOset m_I3;
        protected SMOset m_I4;
        protected SMOset m_supportVectors;
        protected Logistic m_logistic = null;
        protected double m_sumOfWeights = 0.0;

        protected BinaryMISMO() {
        }

        protected void fitLogistic(Instances insts, int cl1, int cl2, int numFolds, Random random) throws Exception {
            FastVector atts = new FastVector(2);
            atts.addElement(new Attribute("pred"));
            FastVector attVals = new FastVector(2);
            attVals.addElement(insts.classAttribute().value(cl1));
            attVals.addElement(insts.classAttribute().value(cl2));
            atts.addElement(new Attribute("class", attVals));
            Instances data = new Instances("data", atts, insts.numInstances());
            data.setClassIndex(1);
            if (numFolds <= 0) {
                for (int j = 0; j < insts.numInstances(); ++j) {
                    Instance inst = insts.instance(j);
                    double[] vals = new double[2];
                    vals[0] = this.SVMOutput(-1, inst);
                    if (inst.classValue() == (double)cl2) {
                        vals[1] = 1.0;
                    }
                    data.add(new Instance(inst.weight(), vals));
                }
            } else {
                if (numFolds > insts.numInstances()) {
                    numFolds = insts.numInstances();
                }
                insts = new Instances(insts);
                insts.randomize(random);
                insts.stratify(numFolds);
                for (int i = 0; i < numFolds; ++i) {
                    Instances train = insts.trainCV(numFolds, i, random);
                    SerializedObject so = new SerializedObject(this);
                    BinaryMISMO smo = (BinaryMISMO)so.getObject();
                    smo.buildClassifier(train, cl1, cl2, false, -1, -1);
                    Instances test = insts.testCV(numFolds, i);
                    for (int j = 0; j < test.numInstances(); ++j) {
                        double[] vals = new double[2];
                        vals[0] = smo.SVMOutput(-1, test.instance(j));
                        if (test.instance(j).classValue() == (double)cl2) {
                            vals[1] = 1.0;
                        }
                        data.add(new Instance(test.instance(j).weight(), vals));
                    }
                }
            }
            this.m_logistic = new Logistic();
            this.m_logistic.buildClassifier(data);
        }

        public void setKernel(Kernel value) {
            this.m_kernel = value;
        }

        public Kernel getKernel() {
            return this.m_kernel;
        }

        protected void buildClassifier(Instances insts, int cl1, int cl2, boolean fitLogistic, int numFolds, int randomSeed) throws Exception {
            int i;
            this.m_bUp = -1.0;
            this.m_bLow = 1.0;
            this.m_b = 0.0;
            this.m_alpha = null;
            this.m_data = null;
            this.m_weights = null;
            this.m_errors = null;
            this.m_logistic = null;
            this.m_I0 = null;
            this.m_I1 = null;
            this.m_I2 = null;
            this.m_I3 = null;
            this.m_I4 = null;
            this.m_sparseWeights = null;
            this.m_sparseIndices = null;
            this.m_sumOfWeights = insts.sumOfWeights();
            this.m_class = new double[insts.numInstances()];
            this.m_iUp = -1;
            this.m_iLow = -1;
            for (i = 0; i < this.m_class.length; ++i) {
                if ((int)insts.instance(i).classValue() == cl1) {
                    this.m_class[i] = -1.0;
                    this.m_iLow = i;
                    continue;
                }
                if ((int)insts.instance(i).classValue() == cl2) {
                    this.m_class[i] = 1.0;
                    this.m_iUp = i;
                    continue;
                }
                throw new Exception("This should never happen!");
            }
            if (this.m_iUp == -1 || this.m_iLow == -1) {
                if (this.m_iUp != -1) {
                    this.m_b = -1.0;
                } else if (this.m_iLow != -1) {
                    this.m_b = 1.0;
                } else {
                    this.m_class = null;
                    return;
                }
                this.m_supportVectors = new SMOset(0);
                this.m_alpha = new double[0];
                this.m_class = new double[0];
                if (fitLogistic) {
                    this.fitLogistic(insts, cl1, cl2, numFolds, new Random(randomSeed));
                }
                return;
            }
            this.m_data = insts;
            this.m_weights = null;
            this.m_alpha = new double[this.m_data.numInstances()];
            this.m_supportVectors = new SMOset(this.m_data.numInstances());
            this.m_I0 = new SMOset(this.m_data.numInstances());
            this.m_I1 = new SMOset(this.m_data.numInstances());
            this.m_I2 = new SMOset(this.m_data.numInstances());
            this.m_I3 = new SMOset(this.m_data.numInstances());
            this.m_I4 = new SMOset(this.m_data.numInstances());
            this.m_sparseWeights = null;
            this.m_sparseIndices = null;
            this.m_errors = new double[this.m_data.numInstances()];
            this.m_errors[this.m_iLow] = 1.0;
            this.m_errors[this.m_iUp] = -1.0;
            this.m_kernel.buildKernel(this.m_data);
            for (i = 0; i < this.m_class.length; ++i) {
                if (this.m_class[i] == 1.0) {
                    this.m_I1.insert(i);
                    continue;
                }
                this.m_I4.insert(i);
            }
            int numChanged = 0;
            boolean examineAll = true;
            while (numChanged > 0 || examineAll) {
                int i2;
                numChanged = 0;
                if (examineAll) {
                    for (i2 = 0; i2 < this.m_alpha.length; ++i2) {
                        if (!this.examineExample(i2)) continue;
                        ++numChanged;
                    }
                } else {
                    for (i2 = 0; i2 < this.m_alpha.length; ++i2) {
                        if (!(this.m_alpha[i2] > 0.0) || !(this.m_alpha[i2] < MISMO.this.m_C * this.m_data.instance(i2).weight())) continue;
                        if (this.examineExample(i2)) {
                            ++numChanged;
                        }
                        if (!(this.m_bUp > this.m_bLow - 2.0 * MISMO.this.m_tol)) continue;
                        numChanged = 0;
                        break;
                    }
                }
                if (examineAll) {
                    examineAll = false;
                    continue;
                }
                if (numChanged != 0) continue;
                examineAll = true;
            }
            this.m_b = (this.m_bLow + this.m_bUp) / 2.0;
            this.m_kernel.clean();
            this.m_errors = null;
            this.m_I4 = null;
            this.m_I3 = null;
            this.m_I2 = null;
            this.m_I1 = null;
            this.m_I0 = null;
            if (fitLogistic) {
                this.fitLogistic(insts, cl1, cl2, numFolds, new Random(randomSeed));
            }
        }

        protected double SVMOutput(int index, Instance inst) throws Exception {
            double result = 0.0;
            int i = this.m_supportVectors.getNext(-1);
            while (i != -1) {
                result += this.m_class[i] * this.m_alpha[i] * this.m_kernel.eval(index, i, inst);
                i = this.m_supportVectors.getNext(i);
            }
            return result -= this.m_b;
        }

        public String toString() {
            StringBuffer text = new StringBuffer();
            int printed = 0;
            if (this.m_alpha == null && this.m_sparseWeights == null) {
                return "BinaryMISMO: No model built yet.\n";
            }
            try {
                text.append("BinaryMISMO\n\n");
                for (int i = 0; i < this.m_alpha.length; ++i) {
                    if (!this.m_supportVectors.contains(i)) continue;
                    double val = this.m_alpha[i];
                    if (this.m_class[i] == 1.0) {
                        if (printed > 0) {
                            text.append(" + ");
                        }
                    } else {
                        text.append(" - ");
                    }
                    text.append(Utils.doubleToString(val, 12, 4) + " * <");
                    for (int j = 0; j < this.m_data.numAttributes(); ++j) {
                        if (j != this.m_data.classIndex()) {
                            text.append(this.m_data.instance(i).toString(j));
                        }
                        if (j == this.m_data.numAttributes() - 1) continue;
                        text.append(" ");
                    }
                    text.append("> * X]\n");
                    ++printed;
                }
                if (this.m_b > 0.0) {
                    text.append(" - " + Utils.doubleToString(this.m_b, 12, 4));
                } else {
                    text.append(" + " + Utils.doubleToString(-this.m_b, 12, 4));
                }
                text.append("\n\nNumber of support vectors: " + this.m_supportVectors.numElements());
                int numEval = 0;
                int numCacheHits = -1;
                if (this.m_kernel != null) {
                    numEval = this.m_kernel.numEvals();
                    numCacheHits = this.m_kernel.numCacheHits();
                }
                text.append("\n\nNumber of kernel evaluations: " + numEval);
                if (numCacheHits >= 0 && numEval > 0) {
                    double hitRatio = 1.0 - (double)numEval * 1.0 / (double)(numCacheHits + numEval);
                    text.append(" (" + Utils.doubleToString(hitRatio * 100.0, 7, 3).trim() + "% cached)");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return "Can't print BinaryMISMO classifier.";
            }
            return text.toString();
        }

        protected boolean examineExample(int i2) throws Exception {
            double F2;
            int i1 = -1;
            double y2 = this.m_class[i2];
            if (this.m_I0.contains(i2)) {
                F2 = this.m_errors[i2];
            } else {
                this.m_errors[i2] = F2 = this.SVMOutput(i2, this.m_data.instance(i2)) + this.m_b - y2;
                if ((this.m_I1.contains(i2) || this.m_I2.contains(i2)) && F2 < this.m_bUp) {
                    this.m_bUp = F2;
                    this.m_iUp = i2;
                } else if ((this.m_I3.contains(i2) || this.m_I4.contains(i2)) && F2 > this.m_bLow) {
                    this.m_bLow = F2;
                    this.m_iLow = i2;
                }
            }
            boolean optimal = true;
            if ((this.m_I0.contains(i2) || this.m_I1.contains(i2) || this.m_I2.contains(i2)) && this.m_bLow - F2 > 2.0 * MISMO.this.m_tol) {
                optimal = false;
                i1 = this.m_iLow;
            }
            if ((this.m_I0.contains(i2) || this.m_I3.contains(i2) || this.m_I4.contains(i2)) && F2 - this.m_bUp > 2.0 * MISMO.this.m_tol) {
                optimal = false;
                i1 = this.m_iUp;
            }
            if (optimal) {
                return false;
            }
            if (this.m_I0.contains(i2)) {
                i1 = this.m_bLow - F2 > F2 - this.m_bUp ? this.m_iLow : this.m_iUp;
            }
            if (i1 == -1) {
                throw new Exception("This should never happen!");
            }
            return this.takeStep(i1, i2, F2);
        }

        protected boolean takeStep(int i1, int i2, double F2) throws Exception {
            double a2;
            double k22;
            double H;
            double L;
            double C1 = MISMO.this.m_C * this.m_data.instance(i1).weight();
            double C2 = MISMO.this.m_C * this.m_data.instance(i2).weight();
            if (i1 == i2) {
                return false;
            }
            double alph1 = this.m_alpha[i1];
            double alph2 = this.m_alpha[i2];
            double y1 = this.m_class[i1];
            double y2 = this.m_class[i2];
            double F1 = this.m_errors[i1];
            double s = y1 * y2;
            if (y1 != y2) {
                L = Math.max(0.0, alph2 - alph1);
                H = Math.min(C2, C1 + alph2 - alph1);
            } else {
                L = Math.max(0.0, alph1 + alph2 - C1);
                H = Math.min(C2, alph1 + alph2);
            }
            if (L >= H) {
                return false;
            }
            double k11 = this.m_kernel.eval(i1, i1, this.m_data.instance(i1));
            double k12 = this.m_kernel.eval(i1, i2, this.m_data.instance(i1));
            double eta = 2.0 * k12 - k11 - (k22 = this.m_kernel.eval(i2, i2, this.m_data.instance(i2)));
            if (eta < 0.0) {
                a2 = alph2 - y2 * (F1 - F2) / eta;
                if (a2 < L) {
                    a2 = L;
                } else if (a2 > H) {
                    a2 = H;
                }
            } else {
                double Hobj;
                double f2;
                double v2;
                double gamma = alph1 + s * alph2;
                double f1 = this.SVMOutput(i1, this.m_data.instance(i1));
                double v1 = f1 + this.m_b - y1 * alph1 * k11 - y2 * alph2 * k12;
                double Lobj = gamma - s * L + L - 0.5 * k11 * (gamma - s * L) * (gamma - s * L) - 0.5 * k22 * L * L - s * k12 * (gamma - s * L) * L - y1 * (gamma - s * L) * v1 - y2 * L * (v2 = (f2 = this.SVMOutput(i2, this.m_data.instance(i2))) + this.m_b - y1 * alph1 * k12 - y2 * alph2 * k22);
                a2 = Lobj > (Hobj = gamma - s * H + H - 0.5 * k11 * (gamma - s * H) * (gamma - s * H) - 0.5 * k22 * H * H - s * k12 * (gamma - s * H) * H - y1 * (gamma - s * H) * v1 - y2 * H * v2) + MISMO.this.m_eps ? L : (Lobj < Hobj - MISMO.this.m_eps ? H : alph2);
            }
            if (Math.abs(a2 - alph2) < MISMO.this.m_eps * (a2 + alph2 + MISMO.this.m_eps)) {
                return false;
            }
            if (a2 > C2 - m_Del * C2) {
                a2 = C2;
            } else if (a2 <= m_Del * C2) {
                a2 = 0.0;
            }
            double a1 = alph1 + s * (alph2 - a2);
            if (a1 > C1 - m_Del * C1) {
                a1 = C1;
            } else if (a1 <= m_Del * C1) {
                a1 = 0.0;
            }
            if (a1 > 0.0) {
                this.m_supportVectors.insert(i1);
            } else {
                this.m_supportVectors.delete(i1);
            }
            if (a1 > 0.0 && a1 < C1) {
                this.m_I0.insert(i1);
            } else {
                this.m_I0.delete(i1);
            }
            if (y1 == 1.0 && a1 == 0.0) {
                this.m_I1.insert(i1);
            } else {
                this.m_I1.delete(i1);
            }
            if (y1 == -1.0 && a1 == C1) {
                this.m_I2.insert(i1);
            } else {
                this.m_I2.delete(i1);
            }
            if (y1 == 1.0 && a1 == C1) {
                this.m_I3.insert(i1);
            } else {
                this.m_I3.delete(i1);
            }
            if (y1 == -1.0 && a1 == 0.0) {
                this.m_I4.insert(i1);
            } else {
                this.m_I4.delete(i1);
            }
            if (a2 > 0.0) {
                this.m_supportVectors.insert(i2);
            } else {
                this.m_supportVectors.delete(i2);
            }
            if (a2 > 0.0 && a2 < C2) {
                this.m_I0.insert(i2);
            } else {
                this.m_I0.delete(i2);
            }
            if (y2 == 1.0 && a2 == 0.0) {
                this.m_I1.insert(i2);
            } else {
                this.m_I1.delete(i2);
            }
            if (y2 == -1.0 && a2 == C2) {
                this.m_I2.insert(i2);
            } else {
                this.m_I2.delete(i2);
            }
            if (y2 == 1.0 && a2 == C2) {
                this.m_I3.insert(i2);
            } else {
                this.m_I3.delete(i2);
            }
            if (y2 == -1.0 && a2 == 0.0) {
                this.m_I4.insert(i2);
            } else {
                this.m_I4.delete(i2);
            }
            int j = this.m_I0.getNext(-1);
            while (j != -1) {
                if (j != i1 && j != i2) {
                    int n = j;
                    this.m_errors[n] = this.m_errors[n] + (y1 * (a1 - alph1) * this.m_kernel.eval(i1, j, this.m_data.instance(i1)) + y2 * (a2 - alph2) * this.m_kernel.eval(i2, j, this.m_data.instance(i2)));
                }
                j = this.m_I0.getNext(j);
            }
            int n = i1;
            this.m_errors[n] = this.m_errors[n] + (y1 * (a1 - alph1) * k11 + y2 * (a2 - alph2) * k12);
            int n2 = i2;
            this.m_errors[n2] = this.m_errors[n2] + (y1 * (a1 - alph1) * k12 + y2 * (a2 - alph2) * k22);
            this.m_alpha[i1] = a1;
            this.m_alpha[i2] = a2;
            this.m_bLow = -1.7976931348623157E308;
            this.m_bUp = Double.MAX_VALUE;
            this.m_iLow = -1;
            this.m_iUp = -1;
            j = this.m_I0.getNext(-1);
            while (j != -1) {
                if (this.m_errors[j] < this.m_bUp) {
                    this.m_bUp = this.m_errors[j];
                    this.m_iUp = j;
                }
                if (this.m_errors[j] > this.m_bLow) {
                    this.m_bLow = this.m_errors[j];
                    this.m_iLow = j;
                }
                j = this.m_I0.getNext(j);
            }
            if (!this.m_I0.contains(i1)) {
                if (this.m_I3.contains(i1) || this.m_I4.contains(i1)) {
                    if (this.m_errors[i1] > this.m_bLow) {
                        this.m_bLow = this.m_errors[i1];
                        this.m_iLow = i1;
                    }
                } else if (this.m_errors[i1] < this.m_bUp) {
                    this.m_bUp = this.m_errors[i1];
                    this.m_iUp = i1;
                }
            }
            if (!this.m_I0.contains(i2)) {
                if (this.m_I3.contains(i2) || this.m_I4.contains(i2)) {
                    if (this.m_errors[i2] > this.m_bLow) {
                        this.m_bLow = this.m_errors[i2];
                        this.m_iLow = i2;
                    }
                } else if (this.m_errors[i2] < this.m_bUp) {
                    this.m_bUp = this.m_errors[i2];
                    this.m_iUp = i2;
                }
            }
            if (this.m_iLow == -1 || this.m_iUp == -1) {
                throw new Exception("This should never happen!");
            }
            return true;
        }

        protected void checkClassifier() throws Exception {
            int i;
            double sum = 0.0;
            for (i = 0; i < this.m_alpha.length; ++i) {
                if (!(this.m_alpha[i] > 0.0)) continue;
                sum += this.m_class[i] * this.m_alpha[i];
            }
            System.err.println("Sum of y(i) * alpha(i): " + sum);
            for (i = 0; i < this.m_alpha.length; ++i) {
                double output = this.SVMOutput(i, this.m_data.instance(i));
                if (Utils.eq(this.m_alpha[i], 0.0) && Utils.sm(this.m_class[i] * output, 1.0)) {
                    System.err.println("KKT condition 1 violated: " + this.m_class[i] * output);
                }
                if (Utils.gr(this.m_alpha[i], 0.0) && Utils.sm(this.m_alpha[i], MISMO.this.m_C * this.m_data.instance(i).weight()) && !Utils.eq(this.m_class[i] * output, 1.0)) {
                    System.err.println("KKT condition 2 violated: " + this.m_class[i] * output);
                }
                if (!Utils.eq(this.m_alpha[i], MISMO.this.m_C * this.m_data.instance(i).weight()) || !Utils.gr(this.m_class[i] * output, 1.0)) continue;
                System.err.println("KKT condition 3 violated: " + this.m_class[i] * output);
            }
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 1.6 $");
        }
    }
}

