/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import weka.associations.ItemSet;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public class LabeledItemSet
extends ItemSet
implements Serializable {
    private static final long serialVersionUID = 4158771925518299903L;
    protected int m_classLabel;
    protected int m_ruleSupCounter;

    public LabeledItemSet(int n, int n2) {
        super(n);
        this.m_classLabel = n2;
    }

    public static FastVector deleteItemSets(FastVector fastVector, int n, int n2) {
        FastVector fastVector2 = new FastVector(fastVector.size());
        for (int i = 0; i < fastVector.size(); ++i) {
            LabeledItemSet labeledItemSet = (LabeledItemSet)fastVector.elementAt(i);
            if (labeledItemSet.m_ruleSupCounter < n || labeledItemSet.m_ruleSupCounter > n2) continue;
            fastVector2.addElement(labeledItemSet);
        }
        return fastVector2;
    }

    public final boolean equals(Object object) {
        if (!this.equalCondset(object)) {
            return false;
        }
        return this.m_classLabel == ((LabeledItemSet)object).m_classLabel;
    }

    public final boolean equalCondset(Object object) {
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        if (this.m_items.length != ((ItemSet)object).items().length) {
            return false;
        }
        for (int i = 0; i < this.m_items.length; ++i) {
            if (this.m_items[i] == ((ItemSet)object).itemAt(i)) continue;
            return false;
        }
        return true;
    }

    public static Hashtable getHashtable(FastVector fastVector, int n) {
        Hashtable<LabeledItemSet, Integer> hashtable = new Hashtable<LabeledItemSet, Integer>(n);
        for (int i = 0; i < fastVector.size(); ++i) {
            LabeledItemSet labeledItemSet = (LabeledItemSet)fastVector.elementAt(i);
            hashtable.put(labeledItemSet, new Integer(labeledItemSet.m_classLabel));
        }
        return hashtable;
    }

    public static FastVector mergeAllItemSets(FastVector fastVector, int n, int n2) {
        FastVector fastVector2 = new FastVector();
        block0: for (int i = 0; i < fastVector.size(); ++i) {
            LabeledItemSet labeledItemSet = (LabeledItemSet)fastVector.elementAt(i);
            for (int j = i + 1; j < fastVector.size(); ++j) {
                LabeledItemSet labeledItemSet2 = (LabeledItemSet)fastVector.elementAt(j);
                while (labeledItemSet.m_classLabel != labeledItemSet2.m_classLabel) {
                    if (++j == fastVector.size()) continue block0;
                    labeledItemSet2 = (LabeledItemSet)fastVector.elementAt(j);
                }
                LabeledItemSet labeledItemSet3 = new LabeledItemSet(n2, labeledItemSet.m_classLabel);
                labeledItemSet3.m_items = new int[labeledItemSet.m_items.length];
                int n3 = 0;
                int n4 = 0;
                while (n3 < n) {
                    if (labeledItemSet.m_items[n4] != labeledItemSet2.m_items[n4]) continue block0;
                    if (labeledItemSet.m_items[n4] != -1) {
                        ++n3;
                    }
                    labeledItemSet3.m_items[n4] = labeledItemSet.m_items[n4];
                    ++n4;
                }
                while (n4 < labeledItemSet.m_items.length && (labeledItemSet.m_items[n4] == -1 || labeledItemSet2.m_items[n4] == -1)) {
                    labeledItemSet3.m_items[n4] = labeledItemSet.m_items[n4] != -1 ? labeledItemSet.m_items[n4] : labeledItemSet2.m_items[n4];
                    ++n4;
                }
                if (n4 != labeledItemSet.m_items.length) continue;
                labeledItemSet3.m_ruleSupCounter = 0;
                labeledItemSet3.m_counter = 0;
                fastVector2.addElement(labeledItemSet3);
            }
        }
        return fastVector2;
    }

    public static Instances divide(Instances instances, boolean bl) throws Exception {
        Instances instances2 = new Instances(instances);
        if (instances.classIndex() < 0) {
            throw new Exception("For class association rule mining a class attribute has to be specified.");
        }
        if (bl) {
            for (int i = 0; i < instances2.numAttributes(); ++i) {
                if (i == instances2.classIndex()) continue;
                instances2.deleteAttributeAt(i);
                --i;
            }
            return instances2;
        }
        instances2.setClassIndex(-1);
        instances2.deleteAttributeAt(instances.classIndex());
        return instances2;
    }

    public static FastVector singletons(Instances instances, Instances instances2) throws Exception {
        FastVector fastVector = new FastVector();
        for (int i = 0; i < instances.numAttributes(); ++i) {
            if (instances.attribute(i).isNumeric()) {
                throw new Exception("Can't handle numeric attributes!");
            }
            for (int j = 0; j < instances.attribute(i).numValues(); ++j) {
                for (int k = 0; k < instances2.attribute(0).numValues(); ++k) {
                    LabeledItemSet labeledItemSet = new LabeledItemSet(instances.numInstances(), k);
                    labeledItemSet.m_items = new int[instances.numAttributes()];
                    for (int i2 = 0; i2 < instances.numAttributes(); ++i2) {
                        labeledItemSet.m_items[i2] = -1;
                    }
                    labeledItemSet.m_items[i] = j;
                    fastVector.addElement(labeledItemSet);
                }
            }
        }
        return fastVector;
    }

    public static FastVector pruneItemSets(FastVector fastVector, Hashtable hashtable) {
        FastVector fastVector2 = new FastVector(fastVector.size());
        for (int i = 0; i < fastVector.size(); ++i) {
            int n;
            LabeledItemSet labeledItemSet = (LabeledItemSet)fastVector.elementAt(i);
            for (n = 0; n < labeledItemSet.m_items.length; ++n) {
                if (labeledItemSet.m_items[n] == -1) continue;
                int n2 = labeledItemSet.m_items[n];
                labeledItemSet.m_items[n] = -1;
                if (hashtable.get(labeledItemSet) != null && labeledItemSet.m_classLabel == (Integer)hashtable.get(labeledItemSet)) {
                    labeledItemSet.m_items[n] = n2;
                    continue;
                }
                labeledItemSet.m_items[n] = n2;
                break;
            }
            if (n != labeledItemSet.m_items.length) continue;
            fastVector2.addElement(labeledItemSet);
        }
        return fastVector2;
    }

    public final int support() {
        return this.m_ruleSupCounter;
    }

    public final void upDateCounter(Instance instance, Instance instance2) {
        if (this.containedBy(instance)) {
            ++this.m_counter;
            if ((double)this.m_classLabel == instance2.value(0)) {
                ++this.m_ruleSupCounter;
            }
        }
    }

    public static void upDateCounters(FastVector fastVector, Instances instances, Instances instances2) {
        for (int i = 0; i < instances.numInstances(); ++i) {
            Enumeration enumeration = fastVector.elements();
            while (enumeration.hasMoreElements()) {
                ((LabeledItemSet)enumeration.nextElement()).upDateCounter(instances.instance(i), instances2.instance(i));
            }
        }
    }

    public final FastVector[] generateRules(double d, boolean bl) {
        FastVector fastVector = new FastVector();
        FastVector fastVector2 = new FastVector();
        FastVector fastVector3 = new FastVector();
        FastVector[] fastVectorArray = new FastVector[3];
        ItemSet itemSet = new ItemSet(this.m_totalTransactions);
        ItemSet itemSet2 = new ItemSet(this.m_totalTransactions);
        int[] nArray = new int[this.m_items.length];
        int[] nArray2 = new int[1];
        System.arraycopy(this.m_items, 0, nArray, 0, this.m_items.length);
        itemSet2.setItem(nArray2);
        itemSet.setItem(nArray);
        itemSet2.setItemAt(this.m_classLabel, 0);
        itemSet2.setCounter(this.m_ruleSupCounter);
        itemSet.setCounter(this.m_counter);
        fastVector.addElement(itemSet);
        fastVector2.addElement(itemSet2);
        fastVector3.addElement(new Double((double)this.m_ruleSupCounter / (double)this.m_counter));
        fastVectorArray[0] = fastVector;
        fastVectorArray[1] = fastVector2;
        fastVectorArray[2] = fastVector3;
        if (!bl) {
            LabeledItemSet.pruneRules(fastVectorArray, d);
        }
        return fastVectorArray;
    }
}

