/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.supportVector;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.functions.supportVector.CachedKernel;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class Puk
extends CachedKernel
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 1682161522559978851L;
    protected double[] m_kernelPrecalc;
    protected double m_omega = 1.0;
    protected double m_sigma = 1.0;
    protected double m_factor = 1.0;

    public Puk() {
    }

    public Puk(Instances instances, int n, double d, double d2) throws Exception {
        this.setCacheSize(n);
        this.setOmega(d);
        this.setSigma(d2);
        this.buildKernel(instances);
    }

    public String globalInfo() {
        return "The Pearson VII function-based universal kernel.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "B. Uestuen and W.J. Melssen and L.M.C. Buydens");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2006");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Facilitating the application of Support Vector Regression by using a universal Pearson VII function based kernel");
        technicalInformation.setValue(TechnicalInformation.Field.JOURNAL, "Chemometrics and Intelligent Laboratory Systems");
        technicalInformation.setValue(TechnicalInformation.Field.VOLUME, "81");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "29-40");
        technicalInformation.setValue(TechnicalInformation.Field.PDF, "http://www.cac.science.ru.nl/research/publications/PDFs/ustun2006.pdf");
        return technicalInformation;
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        vector.addElement(new Option("\tThe Omega parameter.\n\t(default: 1.0)", "O", 1, "-O <num>"));
        vector.addElement(new Option("\tThe Sigma parameter.\n\t(default: 1.0)", "S", 1, "-S <num>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('O', stringArray);
        if (string.length() != 0) {
            this.setOmega(Double.parseDouble(string));
        } else {
            this.setOmega(1.0);
        }
        string = Utils.getOption('S', stringArray);
        if (string.length() != 0) {
            this.setSigma(Double.parseDouble(string));
        } else {
            this.setSigma(1.0);
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-O");
        vector.add("" + this.getOmega());
        vector.add("-S");
        vector.add("" + this.getSigma());
        return vector.toArray(new String[vector.size()]);
    }

    protected double evaluate(int n, int n2, Instance instance) throws Exception {
        if (n == n2) {
            return 1.0;
        }
        double d = n == -1 ? this.dotProd(instance, instance) : this.m_kernelPrecalc[n];
        Instance instance2 = this.m_data.instance(n2);
        double d2 = -2.0 * this.dotProd(instance, instance2) + d + this.m_kernelPrecalc[n2];
        double d3 = this.m_factor * Math.sqrt(d2);
        double d4 = 1.0 / Math.pow(1.0 + d3 * d3, this.getOmega());
        return d4;
    }

    public void setOmega(double d) {
        this.m_omega = d;
        this.m_factor = this.computeFactor(this.m_omega, this.m_sigma);
    }

    public double getOmega() {
        return this.m_omega;
    }

    public String omegaTipText() {
        return "The Omega value.";
    }

    public void setSigma(double d) {
        this.m_sigma = d;
        this.m_factor = this.computeFactor(this.m_omega, this.m_sigma);
    }

    public double getSigma() {
        return this.m_sigma;
    }

    public String sigmaTipText() {
        return "The Sigma value.";
    }

    protected double computeFactor(double d, double d2) {
        double d3 = Math.sqrt(Math.pow(2.0, 1.0 / d) - 1.0);
        return 2.0 * d3 / d2;
    }

    protected void initVars(Instances instances) {
        super.initVars(instances);
        this.m_factor = this.computeFactor(this.m_omega, this.m_sigma);
        this.m_kernelPrecalc = new double[instances.numInstances()];
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enableAllClasses();
        return capabilities;
    }

    public void buildKernel(Instances instances) throws Exception {
        if (!this.getChecksTurnedOff()) {
            this.getCapabilities().testWithFail(instances);
        }
        this.initVars(instances);
        for (int i = 0; i < instances.numInstances(); ++i) {
            this.m_kernelPrecalc[i] = this.dotProd(instances.instance(i), instances.instance(i));
        }
    }

    public String toString() {
        return "Puk kernel";
    }
}

