/*
 * Decompiled with CFR 0.152.
 */
package weka.filters;

import weka.core.Instance;
import weka.core.Instances;
import weka.filters.SimpleFilter;

public abstract class SimpleBatchFilter
extends SimpleFilter {
    private static final long serialVersionUID = 8102908673378055114L;

    protected boolean hasImmediateOutputFormat() {
        return false;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        this.bufferInput(instance);
        if (this.isFirstBatchDone()) {
            try {
                Instances instances = new Instances(this.getInputFormat());
                instances = this.process(instances);
                for (int i = 0; i < instances.numInstances(); ++i) {
                    this.push(instances.instance(i));
                }
                this.flushInput();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.m_FirstBatchDone;
    }

    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        try {
            Instances instances = new Instances(this.getInputFormat());
            if (!this.hasImmediateOutputFormat() && !this.isFirstBatchDone()) {
                this.setOutputFormat(this.determineOutputFormat(new Instances(instances, 0)));
            }
            if (instances.numInstances() > 0) {
                instances = this.process(instances);
                this.flushInput();
                for (int i = 0; i < instances.numInstances(); ++i) {
                    this.push(instances.instance(i));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_NewBatch = true;
        this.m_FirstBatchDone = true;
        return this.numPendingOutput() != 0;
    }
}

