/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import weka.classifiers.Classifier;
import weka.classifiers.IteratedSingleClassifierEnhancer;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Utils;

public abstract class ParallelIteratedSingleClassifierEnhancer
extends IteratedSingleClassifierEnhancer {
    private static final long serialVersionUID = -5026378741833046436L;
    protected int m_numExecutionSlots = 1;

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(2);
        newVector.addElement(new Option("\tNumber of execution slots.\n\t(default 1 - i.e. no parallelism)\n\t(use 0 to auto-detect number of cores)", "num-slots", 1, "-num-slots <num>"));
        newVector.addAll(Collections.list(super.listOptions()));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String iterations = Utils.getOption("num-slots", options);
        if (iterations.length() != 0) {
            this.setNumExecutionSlots(Integer.parseInt(iterations));
        } else {
            this.setNumExecutionSlots(1);
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        String[] superOptions = super.getOptions();
        String[] options = new String[superOptions.length + 2];
        int current = 0;
        options[current++] = "-num-slots";
        options[current++] = "" + this.getNumExecutionSlots();
        System.arraycopy(superOptions, 0, options, current, superOptions.length);
        return options;
    }

    public void setNumExecutionSlots(int numSlots) {
        this.m_numExecutionSlots = numSlots;
    }

    public int getNumExecutionSlots() {
        return this.m_numExecutionSlots;
    }

    public String numExecutionSlotsTipText() {
        return "The number of execution slots (threads) to use for constructing the ensemble.";
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        super.buildClassifier(data);
        if (this.m_numExecutionSlots < 0) {
            throw new Exception("Number of execution slots needs to be >= 0!");
        }
    }

    protected void buildClassifiers() throws Exception {
        if (this.m_numExecutionSlots != 1) {
            int numCores = this.m_numExecutionSlots == 0 ? Runtime.getRuntime().availableProcessors() : this.m_numExecutionSlots;
            ExecutorService executorPool = Executors.newFixedThreadPool(numCores);
            final CountDownLatch doneSignal = new CountDownLatch(this.m_Classifiers.length);
            final AtomicInteger numFailed = new AtomicInteger();
            for (int i = 0; i < this.m_Classifiers.length; ++i) {
                final Classifier currentClassifier = this.m_Classifiers[i];
                if (currentClassifier == null) continue;
                final int iteration = i;
                if (this.m_Debug) {
                    System.out.print("Training classifier (" + (i + 1) + ")");
                }
                Runnable newTask = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            currentClassifier.buildClassifier(ParallelIteratedSingleClassifierEnhancer.this.getTrainingSet(iteration));
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            numFailed.incrementAndGet();
                            if (ParallelIteratedSingleClassifierEnhancer.this.m_Debug) {
                                System.err.println("Iteration " + iteration + " failed!");
                            }
                        }
                        finally {
                            doneSignal.countDown();
                        }
                    }
                };
                executorPool.submit(newTask);
            }
            doneSignal.await();
            executorPool.shutdownNow();
            if (this.m_Debug && numFailed.intValue() > 0) {
                System.err.println("Problem building classifiers - some iterations failed.");
            }
        } else {
            for (int i = 0; i < this.m_Classifiers.length; ++i) {
                this.m_Classifiers[i].buildClassifier(this.getTrainingSet(i));
            }
        }
    }

    protected abstract Instances getTrainingSet(int var1) throws Exception;
}

