/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.rules.ZeroR;
import weka.core.Capabilities;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;

public abstract class MultipleClassifiersCombiner
extends AbstractClassifier {
    private static final long serialVersionUID = 2776436621129422119L;
    protected Classifier[] m_Classifiers = new Classifier[]{new ZeroR()};

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(1);
        newVector.addElement(new Option("\tFull class name of classifier to include, followed\n\tby scheme options. May be specified multiple times.\n\t(default: \"weka.classifiers.rules.ZeroR\")", "B", 1, "-B <classifier specification>"));
        newVector.addAll(Collections.list(super.listOptions()));
        for (Classifier classifier : this.getClassifiers()) {
            if (!(classifier instanceof OptionHandler)) continue;
            newVector.addElement(new Option("", "", 0, "\nOptions specific to classifier " + classifier.getClass().getName() + ":"));
            newVector.addAll(Collections.list(((OptionHandler)((Object)classifier)).listOptions()));
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String classifierString;
        Vector<Classifier> classifiers = new Vector<Classifier>();
        while ((classifierString = Utils.getOption('B', options)).length() != 0) {
            String[] classifierSpec = Utils.splitOptions(classifierString);
            if (classifierSpec.length == 0) {
                throw new IllegalArgumentException("Invalid classifier specification string");
            }
            String classifierName = classifierSpec[0];
            classifierSpec[0] = "";
            classifiers.addElement(AbstractClassifier.forName(classifierName, classifierSpec));
        }
        if (classifiers.size() == 0) {
            classifiers.addElement(new ZeroR());
        }
        Classifier[] classifiersArray = new Classifier[classifiers.size()];
        for (int i = 0; i < classifiersArray.length; ++i) {
            classifiersArray[i] = (Classifier)classifiers.elementAt(i);
        }
        this.setClassifiers(classifiersArray);
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            options.add("-B");
            options.add("" + this.getClassifierSpec(i));
        }
        Collections.addAll(options, super.getOptions());
        return options.toArray(new String[0]);
    }

    public String classifiersTipText() {
        return "The base classifiers to be used.";
    }

    public void setClassifiers(Classifier[] classifiers) {
        this.m_Classifiers = classifiers;
    }

    public Classifier[] getClassifiers() {
        return this.m_Classifiers;
    }

    public Classifier getClassifier(int index) {
        return this.m_Classifiers[index];
    }

    protected String getClassifierSpec(int index) {
        if (this.m_Classifiers.length < index) {
            return "";
        }
        Classifier c = this.getClassifier(index);
        return c.getClass().getName() + " " + Utils.joinOptions(((OptionHandler)((Object)c)).getOptions());
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result;
        if (this.getClassifiers().length == 0) {
            result = new Capabilities(this);
            result.disableAll();
        } else {
            result = (Capabilities)this.getClassifier(0).getCapabilities().clone();
            for (int i = 1; i < this.getClassifiers().length; ++i) {
                result.and(this.getClassifier(i).getCapabilities());
            }
        }
        for (Capabilities.Capability cap : Capabilities.Capability.values()) {
            result.enableDependency(cap);
        }
        result.setOwner(this);
        return result;
    }
}

