/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.BatchConverter;
import weka.core.converters.URLSourcedLoader;
import weka.core.json.JSONInstances;
import weka.core.json.JSONNode;

public class JSONLoader
extends AbstractFileLoader
implements BatchConverter,
URLSourcedLoader {
    private static final long serialVersionUID = 3764533621135196582L;
    public static String FILE_EXTENSION = ".json";
    public static String FILE_EXTENSION_COMPRESSED = FILE_EXTENSION + ".gz";
    protected String m_URL = "http://";
    protected transient Reader m_sourceReader = null;
    protected JSONNode m_JSON;

    public String globalInfo() {
        return "Reads a source that is in the JSON format.\nIt automatically decompresses the data if the extension is '" + FILE_EXTENSION_COMPRESSED + "'.\n\n" + "For more information, see JSON homepage:\n" + "http://www.json.org/";
    }

    @Override
    public String getFileExtension() {
        return FILE_EXTENSION;
    }

    @Override
    public String[] getFileExtensions() {
        return new String[]{FILE_EXTENSION, FILE_EXTENSION_COMPRESSED};
    }

    @Override
    public String getFileDescription() {
        return "JSON Instances files";
    }

    @Override
    public void reset() throws IOException {
        this.m_structure = null;
        this.m_JSON = null;
        this.setRetrieval(0);
        if (this.m_File != null) {
            this.setFile(new File(this.m_File));
        } else if (this.m_URL != null && !this.m_URL.equals("http://")) {
            this.setURL(this.m_URL);
        }
    }

    @Override
    public void setSource(File file) throws IOException {
        this.m_structure = null;
        this.m_JSON = null;
        this.setRetrieval(0);
        if (file == null) {
            throw new IOException("Source file object is null!");
        }
        try {
            if (file.getName().endsWith(FILE_EXTENSION_COMPRESSED)) {
                this.setSource(new GZIPInputStream(new FileInputStream(file)));
            } else {
                this.setSource(new FileInputStream(file));
            }
        }
        catch (FileNotFoundException ex) {
            throw new IOException("File not found");
        }
        this.m_sourceFile = file;
        this.m_File = file.getAbsolutePath();
    }

    public void setSource(URL url) throws IOException {
        this.m_structure = null;
        this.m_JSON = null;
        this.setRetrieval(0);
        this.setSource(url.openStream());
        this.m_URL = url.toString();
    }

    @Override
    public void setURL(String url) throws IOException {
        this.m_URL = url;
        this.setSource(new URL(url));
    }

    @Override
    public String retrieveURL() {
        return this.m_URL;
    }

    @Override
    public void setSource(InputStream in) throws IOException {
        this.m_File = new File(System.getProperty("user.dir")).getAbsolutePath();
        this.m_URL = "http://";
        this.m_sourceReader = new BufferedReader(new InputStreamReader(in));
    }

    @Override
    public Instances getStructure() throws IOException {
        if (this.m_sourceReader == null) {
            throw new IOException("No source has been specified");
        }
        if (this.m_structure == null) {
            try {
                this.m_JSON = JSONNode.read(this.m_sourceReader);
                this.m_structure = new Instances(JSONInstances.toHeader(this.m_JSON), 0);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return new Instances(this.m_structure, 0);
    }

    @Override
    public Instances getDataSet() throws IOException {
        if (this.m_sourceReader == null) {
            throw new IOException("No source has been specified");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Cannot mix getting Instances in both incremental and batch modes");
        }
        this.setRetrieval(1);
        if (this.m_structure == null) {
            this.getStructure();
        }
        try {
            this.m_sourceReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return JSONInstances.toInstances(this.m_JSON);
    }

    @Override
    public Instance getNextInstance(Instances structure) throws IOException {
        throw new IOException("JSONLoader can't read data sets incrementally.");
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] args) {
        JSONLoader.runFileLoader(new JSONLoader(), args);
    }
}

