/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;

public class NominalToString
extends Filter
implements UnsupervisedFilter,
OptionHandler {
    static final long serialVersionUID = 8655492378380068939L;
    private Range m_AttIndex = new Range("last");

    public String globalInfo() {
        return "Converts a nominal attribute (that is, a set number of values) to string (that is, an unspecified number of values).";
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.m_AttIndex.setUpper(instanceInfo.numAttributes() - 1);
        return false;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.isOutputFormatDefined()) {
            Instance newInstance = (Instance)instance.copy();
            this.push(newInstance);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (!this.isOutputFormatDefined()) {
            this.setOutputFormat();
            for (int i = 0; i < this.getInputFormat().numInstances(); ++i) {
                this.push((Instance)this.getInputFormat().instance(i).copy());
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tSets the range of attributes to convert (default last).", "C", 1, "-C <col>"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('C', options);
        if (tmpStr.length() != 0) {
            this.setAttributeIndexes(tmpStr);
        } else {
            this.setAttributeIndexes("last");
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-C");
        result.add("" + this.getAttributeIndexes());
        return result.toArray(new String[result.size()]);
    }

    public String attributeIndexesTipText() {
        return "Sets a range attributes to process. Any non-nominal attributes in the range are left untouched (\"first\" and \"last\" are valid values)";
    }

    public String getAttributeIndexes() {
        return this.m_AttIndex.getRanges();
    }

    public void setAttributeIndexes(String attIndex) {
        this.m_AttIndex.setRanges(attIndex);
    }

    private void setOutputFormat() {
        FastVector<Attribute> newAtts = new FastVector<Attribute>(this.getInputFormat().numAttributes());
        for (int j = 0; j < this.getInputFormat().numAttributes(); ++j) {
            Attribute att = this.getInputFormat().attribute(j);
            if (!att.isNominal() || !this.m_AttIndex.isInRange(j)) {
                newAtts.addElement(att);
                continue;
            }
            newAtts.addElement(new Attribute(att.name(), (List<String>)null));
        }
        Instances newData = new Instances(this.getInputFormat().relationName(), newAtts, 0);
        newData.setClassIndex(this.getInputFormat().classIndex());
        this.setOutputFormat(newData);
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 6246 $");
    }

    public static void main(String[] args) {
        NominalToString.runFilter(new NominalToString(), args);
    }
}

