/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators;

import weka.core.Capabilities;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.estimators.Estimator;
import weka.estimators.IncrementalEstimator;

public class PoissonEstimator
extends Estimator
implements IncrementalEstimator {
    private static final long serialVersionUID = 7669362595289236662L;
    private double m_NumValues;
    private double m_SumOfValues;
    private double m_Lambda;

    private double logFac(double x) {
        double result = 0.0;
        for (double i = 2.0; i <= x; i += 1.0) {
            result += Math.log(i);
        }
        return result;
    }

    private double Poisson(double x) {
        return Math.exp(-this.m_Lambda + x * Math.log(this.m_Lambda) - this.logFac(x));
    }

    public void addValue(double data, double weight) {
        this.m_NumValues += weight;
        this.m_SumOfValues += data * weight;
        if (this.m_NumValues != 0.0) {
            this.m_Lambda = this.m_SumOfValues / this.m_NumValues;
        }
    }

    public double getProbability(double data) {
        return this.Poisson(data);
    }

    public String toString() {
        return "Poisson Lambda = " + Utils.doubleToString(this.m_Lambda, 4, 2) + "\n";
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        if (!this.m_noClass) {
            result.enable(Capabilities.Capability.NOMINAL_CLASS);
            result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        } else {
            result.enable(Capabilities.Capability.NO_CLASS);
        }
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5490 $");
    }

    public static void main(String[] argv) {
        try {
            if (argv.length == 0) {
                System.out.println("Please specify a set of instances.");
                return;
            }
            PoissonEstimator newEst = new PoissonEstimator();
            for (int i = 0; i < argv.length; ++i) {
                double current = Double.valueOf(argv[i]);
                System.out.println(newEst);
                System.out.println("Prediction for " + current + " = " + newEst.getProbability(current));
                newEst.addValue(current, 1.0);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

