/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators;

import weka.core.matrix.CholeskyDecomposition;
import weka.core.matrix.Matrix;
import weka.estimators.MultivariateEstimator;

public class MultivariateNormalEstimator
implements MultivariateEstimator,
Cloneable {
    protected double[] mean;
    protected double[][] covariance;
    private CholeskyDecomposition chol;
    private double lnconstant;
    public static final double Log2PI = 1.8378770664093456;

    public MultivariateNormalEstimator clone() {
        MultivariateNormalEstimator clone = new MultivariateNormalEstimator();
        clone.mean = this.mean;
        clone.covariance = this.covariance;
        clone.lnconstant = this.lnconstant;
        if (this.chol != null) {
            clone.chol = new CholeskyDecomposition((Matrix)this.chol.getL().clone());
        }
        return clone;
    }

    public MultivariateNormalEstimator() {
    }

    public MultivariateNormalEstimator(double[] means, double[][] covariance) {
        this.mean = means;
        this.covariance = covariance;
        this.chol = new CholeskyDecomposition(new Matrix(covariance));
    }

    public double getProbability(double[] value) {
        double prob = Math.exp(this.logDensity(value));
        return prob > 1.0 ? 1.0 : prob;
    }

    public double logDensity(double[] valuePassed) {
        int i;
        int k;
        double[] value = (double[])valuePassed.clone();
        double logProb = 0.0;
        double[] subtractedMean = new double[value.length];
        for (int i2 = 0; i2 < value.length; ++i2) {
            subtractedMean[i2] = value[i2] - this.mean[i2];
        }
        double[][] L = this.chol.getL().getArray();
        int n = this.chol.getL().getRowDimension();
        for (k = 0; k < this.chol.getL().getRowDimension(); ++k) {
            for (i = 0; i < k; ++i) {
                int n2 = k;
                value[n2] = value[n2] - value[i] * L[k][i];
            }
            int n3 = k;
            value[n3] = value[n3] / L[k][k];
        }
        for (k = n - 1; k >= 0; --k) {
            for (i = k + 1; i < n; ++i) {
                int n4 = k;
                value[n4] = value[n4] - value[i] * L[i][k];
            }
            int n5 = k;
            value[n5] = value[n5] / L[k][k];
        }
        double innerProduct = 0.0;
        for (int i3 = 0; i3 < value.length; ++i3) {
            innerProduct += value[i3] * subtractedMean[i3];
        }
        logProb = this.lnconstant - innerProduct * 0.5;
        return logProb;
    }

    public void estimate(double[][] observations, double[] weights) {
        double[][] cov;
        double[] means;
        if (weights != null) {
            double sum = 0.0;
            for (int i = 0; i < weights.length; ++i) {
                if (Double.isNaN(weights[i]) || Double.isInfinite(weights[i])) {
                    throw new IllegalArgumentException("Invalid numbers in the weight vector");
                }
                sum += weights[i];
            }
            if (Math.abs(sum - 1.0) > 1.0E-10) {
                throw new IllegalArgumentException("Weights do not sum to one");
            }
            means = this.weightedMean(observations, weights, 0);
            cov = this.weightedCovariance(observations, weights, means);
        } else {
            means = this.mean(observations);
            cov = MultivariateNormalEstimator.covariance(observations, means);
        }
        CholeskyDecomposition chol = new CholeskyDecomposition(new Matrix(cov));
        this.recalculate(means, cov, chol);
    }

    public double[] getMean() {
        return this.mean;
    }

    public double[][] getCovariance() {
        return this.covariance;
    }

    private void recalculate(double[] m, double[][] cov, CholeskyDecomposition cd) {
        int k = m.length;
        this.mean = m;
        this.covariance = cov;
        this.chol = cd;
        double lndet = this.getLogDeterminant(cd.getL());
        this.lnconstant = -(1.8378770664093456 * (double)k + lndet) * 0.5;
    }

    private double getLogDeterminant(Matrix L) {
        double detL = 0.0;
        int n = L.getRowDimension();
        double[][] matrixAsArray = L.getArray();
        for (int i = 0; i < n; ++i) {
            detL += Math.log(matrixAsArray[i][i]);
        }
        double logDeterminant = detL * 2.0;
        return logDeterminant;
    }

    private double[] mean(double[][] matrix, double[] weights) {
        return this.weightedMean(matrix, weights, 0);
    }

    private double[] weightedMean(double[][] matrix, double[] weights, int columnSum) {
        double[] mean;
        int rows = matrix.length;
        if (rows == 0) {
            return new double[0];
        }
        int cols = matrix[0].length;
        if (columnSum == 0) {
            mean = new double[cols];
            for (int i = 0; i < rows; ++i) {
                double[] row = matrix[i];
                double w = weights[i];
                for (int j = 0; j < cols; ++j) {
                    int n = j;
                    mean[n] = mean[n] + row[j] * w;
                }
            }
        } else if (columnSum == 1) {
            mean = new double[rows];
            for (int j = 0; j < rows; ++j) {
                double[] row = matrix[j];
                double w = weights[j];
                for (int i = 0; i < cols; ++i) {
                    int n = j;
                    mean[n] = mean[n] + row[i] * w;
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid dimension");
        }
        return mean;
    }

    private double[][] weightedCovariance(double[][] matrix, double[] weights, double[] means) {
        double sw = 1.0;
        for (int i = 0; i < weights.length; ++i) {
            sw -= weights[i] * weights[i];
        }
        return this.weightedScatter(matrix, weights, means, sw, 0);
    }

    private double[][] weightedScatter(double[][] matrix, double[] weights, double[] means, double divisor, int dimension) {
        double[][] cov;
        int rows = matrix.length;
        if (rows == 0) {
            return new double[0][0];
        }
        int cols = matrix[0].length;
        if (dimension == 0) {
            if (means.length != cols) {
                throw new IllegalArgumentException("Length of the mean vector should equal the number of columns");
            }
            cov = new double[cols][cols];
            for (int i = 0; i < cols; ++i) {
                for (int j = i; j < cols; ++j) {
                    double s = 0.0;
                    for (int k = 0; k < rows; ++k) {
                        s += weights[k] * (matrix[k][j] - means[j]) * (matrix[k][i] - means[i]);
                    }
                    cov[i][j] = s /= divisor;
                    cov[j][i] = s;
                }
            }
        } else if (dimension == 1) {
            if (means.length != rows) {
                throw new IllegalArgumentException("Length of the mean vector should equal the number of rows");
            }
            cov = new double[rows][rows];
            for (int i = 0; i < rows; ++i) {
                for (int j = i; j < rows; ++j) {
                    double s = 0.0;
                    for (int k = 0; k < cols; ++k) {
                        s += weights[k] * (matrix[j][k] - means[j]) * (matrix[i][k] - means[i]);
                    }
                    cov[i][j] = s /= divisor;
                    cov[j][i] = s;
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid dimension");
        }
        return cov;
    }

    private double[] mean(double[][] matrix) {
        return this.mean(matrix, 0);
    }

    private double[] mean(double[][] matrix, int dimension) {
        double[] mean;
        int rows = matrix.length;
        int cols = matrix[0].length;
        if (dimension == 0) {
            mean = new double[cols];
            double N = rows;
            int j = 0;
            while (j < cols) {
                for (int i = 0; i < rows; ++i) {
                    int n = j;
                    mean[n] = mean[n] + matrix[i][j];
                }
                int n = j++;
                mean[n] = mean[n] / N;
            }
        } else if (dimension == 1) {
            mean = new double[rows];
            double N = cols;
            int j = 0;
            while (j < rows) {
                for (int i = 0; i < cols; ++i) {
                    int n = j;
                    mean[n] = mean[n] + matrix[j][i];
                }
                int n = j++;
                mean[n] = mean[n] / N;
            }
        } else {
            throw new IllegalArgumentException("Invalid dimension");
        }
        return mean;
    }

    public static double[][] covariance(double[][] matrix, double[] means) {
        return MultivariateNormalEstimator.scatter(matrix, means, matrix.length - 1, 0);
    }

    public static double[][] scatter(double[][] matrix, double[] means, double divisor, int dimension) {
        double[][] cov;
        int rows = matrix.length;
        if (rows == 0) {
            return new double[0][0];
        }
        int cols = matrix[0].length;
        if (dimension == 0) {
            if (means.length != cols) {
                throw new IllegalArgumentException("Length of the mean vector should equal the number of columns");
            }
            cov = new double[cols][cols];
            for (int i = 0; i < cols; ++i) {
                for (int j = i; j < cols; ++j) {
                    double s = 0.0;
                    for (int k = 0; k < rows; ++k) {
                        s += (matrix[k][j] - means[j]) * (matrix[k][i] - means[i]);
                    }
                    cov[i][j] = s /= divisor;
                    cov[j][i] = s;
                }
            }
        } else if (dimension == 1) {
            if (means.length != rows) {
                throw new IllegalArgumentException("Length of the mean vector should equal the number of rows");
            }
            cov = new double[rows][rows];
            for (int i = 0; i < rows; ++i) {
                for (int j = i; j < rows; ++j) {
                    double s = 0.0;
                    for (int k = 0; k < cols; ++k) {
                        s += (matrix[j][k] - means[j]) * (matrix[i][k] - means[i]);
                    }
                    cov[i][j] = s /= divisor;
                    cov[j][i] = s;
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid dimension");
        }
        return cov;
    }

    public static void main(String[] args) {
        double[][] dataset = new double[4][3];
        dataset[0][0] = 10.0;
        dataset[0][1] = 3.0;
        dataset[0][2] = 38.0;
        dataset[1][0] = 12.0;
        dataset[1][1] = 4.0;
        dataset[1][2] = 34.0;
        dataset[2][0] = 20.0;
        dataset[2][1] = 10.0;
        dataset[2][2] = 74.0;
        dataset[3][0] = 10.0;
        dataset[3][1] = 1.0;
        dataset[3][2] = 40.0;
        MultivariateNormalEstimator mv = new MultivariateNormalEstimator();
        mv.estimate(dataset, new double[]{0.7, 0.2, 0.05, 0.05});
        double[] newData = new double[]{12.0, 4.0, 34.0};
        System.out.println(mv.getProbability(newData));
    }
}

