/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import java.io.Serializable;
import weka.classifiers.trees.j48.Distribution;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.Utils;

public abstract class ClassifierSplitModel
implements Cloneable,
Serializable,
RevisionHandler {
    private static final long serialVersionUID = 4280730118393457457L;
    protected Distribution m_distribution;
    protected int m_numSubsets;

    public Object clone() {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public abstract void buildClassifier(Instances var1) throws Exception;

    public final boolean checkModel() {
        return this.m_numSubsets > 0;
    }

    public final double classifyInstance(Instance instance) throws Exception {
        int theSubset = this.whichSubset(instance);
        if (theSubset > -1) {
            return this.m_distribution.maxClass(theSubset);
        }
        return this.m_distribution.maxClass();
    }

    public double classProb(int classIndex, Instance instance, int theSubset) throws Exception {
        if (theSubset > -1) {
            return this.m_distribution.prob(classIndex, theSubset);
        }
        double[] weights = this.weights(instance);
        if (weights == null) {
            return this.m_distribution.prob(classIndex);
        }
        double prob = 0.0;
        for (int i = 0; i < weights.length; ++i) {
            prob += weights[i] * this.m_distribution.prob(classIndex, i);
        }
        return prob;
    }

    public double classProbLaplace(int classIndex, Instance instance, int theSubset) throws Exception {
        if (theSubset > -1) {
            return this.m_distribution.laplaceProb(classIndex, theSubset);
        }
        double[] weights = this.weights(instance);
        if (weights == null) {
            return this.m_distribution.laplaceProb(classIndex);
        }
        double prob = 0.0;
        for (int i = 0; i < weights.length; ++i) {
            prob += weights[i] * this.m_distribution.laplaceProb(classIndex, i);
        }
        return prob;
    }

    public double codingCost() {
        return 0.0;
    }

    public final Distribution distribution() {
        return this.m_distribution;
    }

    public abstract String leftSide(Instances var1);

    public abstract String rightSide(int var1, Instances var2);

    public final String dumpLabel(int index, Instances data) throws Exception {
        StringBuffer text = new StringBuffer();
        text.append(data.classAttribute().value(this.m_distribution.maxClass(index)));
        text.append(" (" + Utils.roundDouble(this.m_distribution.perBag(index), 2));
        if (Utils.gr(this.m_distribution.numIncorrect(index), 0.0)) {
            text.append("/" + Utils.roundDouble(this.m_distribution.numIncorrect(index), 2));
        }
        text.append(")");
        return text.toString();
    }

    public final String sourceClass(int index, Instances data) throws Exception {
        System.err.println("sourceClass");
        return new StringBuffer(this.m_distribution.maxClass(index)).toString();
    }

    public abstract String sourceExpression(int var1, Instances var2);

    public final String dumpModel(Instances data) throws Exception {
        StringBuffer text = new StringBuffer();
        for (int i = 0; i < this.m_numSubsets; ++i) {
            text.append(this.leftSide(data) + this.rightSide(i, data) + ": ");
            text.append(this.dumpLabel(i, data) + "\n");
        }
        return text.toString();
    }

    public final int numSubsets() {
        return this.m_numSubsets;
    }

    public void resetDistribution(Instances data) throws Exception {
        this.m_distribution = new Distribution(data, this);
    }

    public void setDistribution(Distribution dist) {
        this.m_distribution = dist;
    }

    public final Instances[] split(Instances data) throws Exception {
        int[] subsetSize = new int[this.m_numSubsets];
        for (Instance instance : data) {
            int subset = this.whichSubset(instance);
            if (subset > -1) {
                int n = subset;
                subsetSize[n] = subsetSize[n] + 1;
                continue;
            }
            double[] weights = this.weights(instance);
            for (int j = 0; j < this.m_numSubsets; ++j) {
                if (!Utils.gr(weights[j], 0.0)) continue;
                int n = j;
                subsetSize[n] = subsetSize[n] + 1;
            }
        }
        Instances[] instances = new Instances[this.m_numSubsets];
        for (int j = 0; j < this.m_numSubsets; ++j) {
            instances[j] = new Instances(data, subsetSize[j]);
        }
        for (Instance instance : data) {
            int subset = this.whichSubset(instance);
            if (subset > -1) {
                instances[subset].add(instance);
                continue;
            }
            double[] weights = this.weights(instance);
            for (int j = 0; j < this.m_numSubsets; ++j) {
                if (!Utils.gr(weights[j], 0.0)) continue;
                instances[j].add(instance);
                instances[j].lastInstance().setWeight(weights[j] * instance.weight());
            }
        }
        return instances;
    }

    public abstract double[] weights(Instance var1);

    public abstract int whichSubset(Instance var1) throws Exception;
}

