% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvdb.R
\name{tvdb}
\alias{tvdb}
\alias{tvdb_down}
\alias{tvdb_load}
\alias{tvdb_vec}
\alias{tvdb_dfr}
\alias{tvdb_list}
\alias{tvdb_pkgs}
\title{Task Views (tvdb.rda)}
\usage{
tvdb_down(dir = ".", repos = getOption("repos")[1])

tvdb_load(filename = "tvdb.rda")

tvdb_vec(tvdb = get("tvdb", envir = .GlobalEnv))

tvdb_dfr(tvdb = get("tvdb", envir = .GlobalEnv))

tvdb_list(tvdb = get("tvdb", envir = .GlobalEnv))

tvdb_pkgs(..., char = NULL, tvdb = get("tvdb", envir = .GlobalEnv))
}
\arguments{
\item{dir}{character. The directory where "tvdb.rda" is saved.
Default value \code{"."} is the current directory.}

\item{repos}{character. The address of your local CRAN.}

\item{filename}{character. The path to file "tvdb.rda".
The default is to read in the current directory.}

\item{tvdb}{list. The list of the task views.}

\item{...}{any format recognized by \code{\link{cnsc}}, except list.
The names of one or several task views.}

\item{char}{(name to) a character vector or a list. Use this argument if
\code{...} fails or if you call the function from another function.
If used, argument \code{...} is ignored.}
}
\description{
\code{tvdb_down} downloads from CRAN the file "Views.rds", a file refreshed every day that
describes the task views available in CRAN for this day, rearranges the list in an
alphabetical order and gives names to the list names, then loads in .GlobalEnv
this list (of class ctvlist) under the name \code{tvdb} and saves it with the filename
\code{tvdb.rda}.

\code{tvdb_load} loads the file \code{filename} in .GlobalEnv under the name \code{tvdb}.
Equivalent to \code{load("tvdb.rda")}.

\code{tvdb_vec} displays the list of the task views. There are 36 task views in August 2018.

\code{tvdb_dfr} extracts from \code{tvdb} a data.frame \emph{version, name, topic}
of the task views.

\code{tvdb_list} extracts from \code{tvdb} the list of the task views and the referenced
packages.

\code{tvdb_pkgs} displays the packages referenced by one or several task views.

Visit \code{\link{s_crandb_tvdb}} to conduct task view maintenance.
}
\examples{
### DOWNLOAD AND VISUALIZE THE TASK VIEWS (tvdb)
## In real life, download tvdb from CRAN or load it from your directory
## with functions tvdb_down() or tvdb_load().
## In this example, we use a small file.
tvdb_load(system.file("data", "ztvdb.rda", package = "RWsearch"))
length(tvdb)

## List the task views
tvdb_vec()
tvdb_dfr()
tvdb_pkgs("Genetics")
lengths(tvdb_list())

## Here, 'lst' is subsetted from the small crandb file.
crandb_load(system.file("data", "zcrandb.rda", package = "RWsearch"))
funIN <- function (x, y) x[match(x, y, nomatch = 0)  > 0]
lst   <- lapply(tvdb_list()[1:2], funIN, crandb$Package) ; lst
\donttest{
if (interactive()) p_display7(lst[[1]], dir = file.path(tempdir(), "ptvdbdown"))
}
}
