% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StemID.R
\name{comppvalue}
\alias{comppvalue}
\title{Computing P-values for Link Significance}
\usage{
comppvalue(object, pthr = 0.01, sensitive = FALSE)
}
\arguments{
\item{object}{\code{Ltree} class object.}

\item{pthr}{p-value cutoff for link significance. This threshold is applied for the calculation of link scores reflecting how uniformly a link is occupied by cells.}

\item{sensitive}{logical. Only relevant when \code{nmode=TRUE} in function \code{projcell}. If \code{TRUE}, then all cells on the most highly significant link are
and the link itself are disregard to test significance of the remaining links with a binomial p-value. Default is \code{FALSE}.}
}
\value{
An Ltree class object with link p-value and occupancy data stored in slot \code{cdata}.
}
\description{
This function computes a p-value for the significance (i.e. over-representation of assigned cells) of each inter-cluster link.
}
\examples{
sc <- SCseq(intestinalDataSmall)
sc <- filterdata(sc)
sc <- compdist(sc)
sc <- clustexp(sc)
sc <- findoutliers(sc)
sc <- comptsne(sc)
ltr <- Ltree(sc)
ltr <- compentropy(ltr)
ltr <- projcells(ltr)
ltr <- lineagegraph(ltr)
ltr <- comppvalue(ltr)
}
