% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_stress.R
\name{mapDistances}
\alias{mapDistances}
\title{Return calculated map distances for an acmap}
\usage{
mapDistances(map, optimization_number = 1)
}
\arguments{
\item{map}{The acmap data object}

\item{optimization_number}{The optimization number}
}
\value{
Returns a matrix of map distances with antigens as rows and sera as
columns.
}
\description{
Takes the acmap object and calculates euclidean distances between antigens
and sera for the currently selected or specified optimization.
}
\seealso{
Other map diagnostic functions: 
\code{\link{agCohesion}()},
\code{\link{bootstrapBlobs}()},
\code{\link{bootstrapMap}()},
\code{\link{checkHemisphering}()},
\code{\link{dimensionTestMap}()},
\code{\link{logtiterTable}()},
\code{\link{map-table-distances}},
\code{\link{mapBootstrapCoords}},
\code{\link{mapRelaxed}()},
\code{\link{mapResiduals}()},
\code{\link{pointStress}},
\code{\link{ptBootstrapBlob}},
\code{\link{ptBootstrapCoords}()},
\code{\link{ptLeverage}},
\code{\link{ptTriangulationBlob}},
\code{\link{recalculateStress}()},
\code{\link{stressTable}()},
\code{\link{tableColbases}()},
\code{\link{tableDistances}()},
\code{\link{triangulationBlobs}()},
\code{\link{unstableMaps}}

Other functions relating to map stress calculation: 
\code{\link{logtiterTable}()},
\code{\link{mapResiduals}()},
\code{\link{pointStress}},
\code{\link{recalculateStress}()},
\code{\link{stressTable}()},
\code{\link{tableColbases}()},
\code{\link{tableDistances}()}
}
\concept{functions relating to map stress calculation}
\concept{map diagnostic functions}
