% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.S.R
\name{make.S}
\alias{make.S}
\title{Define Dimensional Anchors around the Unit Circle}
\usage{
make.S(x)
}
\arguments{
\item{x}{a vector of dimensional anchors or the number of anchors to put on the circle}
}
\value{
A matrix with 2 columns (x and y coordinates of dimensional anchors) and 1 line
         per dimensional anchor (so called springs). If x is a vector, the row names of
         the matrix will be set to the syntactically correct version of values in the vector
         (through a call to \code{\link[base]{make.names}}). Please note that some functions
         expect to match column names of data to row names of the spring matrix.
}
\description{
make.S will return xy coordinates for n dimensional anchors equally spaced around the unit circle
}
\details{
If x is a vector, values will be used to set the row names of the matrix.
}
\examples{
data(iris)
das <- c('Sepal.Length','Sepal.Width','Petal.Length','Petal.Width')
make.S(length(das)) # without row names
make.S(das) # with row names

}
\author{
Yann Abraham
}

