% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec-distance.R
\name{euclidean_distance}
\alias{euclidean_distance}
\title{Distance Calculations}
\usage{
euclidean_distance(.data, .x, .y, .pull_vector = FALSE)
}
\arguments{
\item{.data}{A data frame}

\item{.x}{A numeric vector}

\item{.y}{A numeric vector}

\item{.pull_vector}{A boolean of TRUE or FALSE. Default is FALSE which will
augment the distance to the data frame. TRUE will return a vector of the distances
as the return.}
}
\value{
A numeric Vector of ditances
}
\description{
A function to calculate the Euclidean distance between two vectors.
}
\details{
A function to calculate the Euclidean distance between two vectors. It uses
the formula \code{sqrt((x - lag(x))^2 + (y - lag(y))^2)}. The function uses augments
the data frame with a new column called \code{distance}.
}
\examples{
set.seed(123)
df <- rw30()
euclidean_distance(df, step_number, y)
euclidean_distance(df, step_number, y, TRUE) |> head(10)

}
\seealso{
Other Vector Function: 
\code{\link{cgmean}()},
\code{\link{chmean}()},
\code{\link{ckurtosis}()},
\code{\link{cmean}()},
\code{\link{cmedian}()},
\code{\link{crange}()},
\code{\link{csd}()},
\code{\link{cskewness}()},
\code{\link{cvar}()},
\code{\link{kurtosis_vec}()},
\code{\link{rw_range}()},
\code{\link{skewness_vec}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Vector Function}
