`mcmcProc` <-
function(v, N, thin=20, burn.in=round(N*thin/100), comp.list, verbose=TRUE)
{
    n <- nrow(v)
    k <- ncol(v)
    M <- (N+burn.in)*thin

    samples <- matrix(0,N+burn.in,k)
    ind <- 1
    last <- comp.list[sample(1:n,n)]    
    
    vs <- sample(1:k, M, replace=TRUE)
    hs <- sample(1:n, M, replace=TRUE)
    unifs <- runif(M)   
    
    if(verbose)
        cat("MCMC: ")   
    for (i in 1:M)
    {      
        x <- last
        vert <- vs[i]
        horz <- hs[i]

        temp <- last[vert]      
        x[vert] <- last[horz]
        x[horz] <- temp
    
        if(horz > k)        
            A <- v[x[vert],vert]/v[last[vert],vert]
        else
            A <- v[x[vert],vert]*v[x[horz],horz]/
                (v[last[vert],vert]*v[last[horz],horz])
    
        if (A > unifs[i]){
            if(i%%thin==0)      
                samples[i/thin,] <- x[1:k]
            last <- x
        }
        else
            if(i%%thin==0)
                samples[i/thin,] <- last[1:k]

        if(i%%(M/10)==0 && verbose)
            cat(paste(i*100/M, "% ",sep=""))
    }
    samples[-(1:burn.in),]
}

