% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rapfunc.R
\name{wakefield_pp_quant}
\alias{wakefield_pp_quant}
\title{Compute posterior probabilities using Wakefield's approximate Bayes Factors for quantitative traits}
\usage{
wakefield_pp_quant(beta, se.beta, sdY, sd.prior = 0.15, pi_i = 1e-04)
}
\arguments{
\item{beta}{a vector of effect sizes (\eqn{\beta}) from a quantitative trait GWAS}

\item{se.beta}{vector of standard errors of effect sizes (\eqn{\beta})}

\item{sdY}{a scalar of the standard deviation given vectors of variance of coefficients,  MAF and sample size. Can be calculated using \code{sdY.est}}

\item{sd.prior}{a scalar representing our prior expectation of \eqn{\beta} (DEFAULT 0.15).}

\item{pi_i}{a scalar representing the prior probability (DEFAULT \eqn{1 \times 10^{-4}})
The method assumes a normal prior on the population log relative risk centred at 0 and the DEFAULT
value sets the variance of this distribution to 0.04, equivalent to a 95\\%  belief that the true relative risk
is in the range of 0.66-1.5 at any causal variant.}
}
\value{
a vector of posterior probabilities.
}
\description{
\code{wakefield_pp_quant} computes posterior probabilities for a given SNP to be causal for a given SNP under the assumption of a single causal variant.
}
\details{
This function was adapted from \code{wakefield_pp} in cupcake package (github.com/ollyburren/cupcake/)
}
\author{
Guillermo Reales, Chris Wallace
}
