% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_headers.R
\name{custom_headers}
\alias{custom_headers}
\title{Modify gtsummary table headers and add a spanning header}
\usage{
custom_headers(
  base_table_missing,
  var_characteristic = NULL,
  show_missing_data = TRUE,
  show_n_per_group = TRUE,
  var_tot = NULL,
  var_group = NULL,
  group_title = NULL,
  table_title
)
}
\arguments{
\item{base_table_missing}{A \code{gtsummary} table object (typically output from previous steps).}

\item{var_characteristic}{Optional. A string to label the features column.}

\item{show_missing_data}{Logical. If \code{TRUE}, adds missing data info to column headers.}

\item{show_n_per_group}{A boolean indicating whether to display group sizes (n) for
each level of the grouping variable.}

\item{var_tot}{Optional. A string to label the total column.}

\item{var_group}{Optional. Name of a grouping variable for adding a spanning header.}

\item{group_title}{Optional. Title for the spanning header. If \code{NULL}, uses the variable label or name.}

\item{table_title}{Title for the entire table.}
}
\value{
A \code{gtsummary} table object with updated headers, spanning header, and caption.
}
\description{
This function customizes the column headers, optional spanning header, and table caption
for a \code{gtsummary} table. It supports adding a feature name, total label, group title, and
formats missing data presentation.
}
