% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_rvi_connections.R
\name{rvn_rvi_connections}
\alias{rvn_rvi_connections}
\title{Generate Hydrological process connections list}
\usage{
rvn_rvi_connections(
  rvi,
  ProcConDataFile = system.file("extdata", "RavenProcessConnections.dat", package =
    "RavenR")
)
}
\arguments{
\item{rvi}{data object generated from the rvn_rvi_read() routine}

\item{ProcConDataFile}{(optional) path to RavenProcesConnections.dat file}
}
\value{
Returns a dataframe of all of the process connections Includes the following data columns:
process type, algorithm, 'from' compartment, 'to' compartment, and conditional.
}
\description{
This routine reads in a hydrologic process list from rvn_rvi_read() and generates
the list of hydrologic process connections.
}
\details{
This function relies on a valid and up-to-date RavenProcessConnections.dat file.
This file is provided with the RavenR package, but
may be overrided by a more recent file if provided manually.
}
\examples{
rvi <- rvn_rvi_read(system.file("extdata","Nith.rvi", package="RavenR"))

# get number of Hydrologic processes
nrow(rvi$HydProcTable)

conn <- rvn_rvi_connections(rvi)
head(conn)

}
\seealso{
\code{\link{rvn_rvi_read}} to read a .rvi file and generate an rvi object, and
\code{\link{rvn_rvi_process_plot}} to plot the process network produced in this function.

See also the \href{http://raven.uwaterloo.ca/}{Raven page}
}
\author{
James R. Craig, University of Waterloo
}
