% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_run.R
\name{rvn_run}
\alias{rvn_run}
\title{Run Raven Executable}
\usage{
rvn_run(
  fileprefix = NULL,
  indir = getwd(),
  ravenexe = NULL,
  outdir = NULL,
  rvc = NULL,
  rvt = NULL,
  rvp = NULL,
  rvh = NULL,
  showoutput = FALSE,
  rvi_options = NULL,
  run_chmod = FALSE
)
}
\arguments{
\item{fileprefix}{file prefix for main Raven input files.}

\item{indir}{string path for Raven input files}

\item{ravenexe}{file path to Raven executable}

\item{outdir}{string path for Raven output files (optional)}

\item{rvc}{file path to specific rvc file (optional)}

\item{rvt}{file path to specific rvt file (optional)}

\item{rvp}{file path to specific rvp file (optional)}

\item{rvh}{file path to specific rvh file (optional)}

\item{showoutput}{boolean whether to show output in console (passed to show.output.on.console within system) (default FALSE)}

\item{rvi_options}{string vector of additional options to add to rvi file temporarily for run}

\item{run_chmod}{runs a chmod system call to the provided executable ('chmod +x') (default \code{FALSE})}
}
\value{
Returns output code from the system command when running Raven
}
\description{
Invokes shell to execute a Raven model.
}
\details{
Uses the \code{\link{shell}} command to run the Raven.exe command.

If the \code{fileprefix} is not supplied, the function will detect the rvi file automatically and
use that in the run (if exactly one rvi file exists in the directory).

The \code{indir} path must point to the main Raven input files, if they are not in the working directory.

The \code{ravenexe} must point to the Raven.exe file; if not supplied it will look for it in the RavenR/extdata
path that is saved to when using \code{\link{rvn_download}}.

\code{rvi_options} can include a vector of any additional commands to add to the rvi file prior to execution. Any
commands are added temporarily, and the rvi file is restored following the Raven run. The original rvi file
is backed up as a copy in case of an interruption of the function or other error to prevent loss of data.
The rvi commands provided are checked against a list of known rvi commands and a warning is issued
if an unrecognized command is provided, but all commands provided are nonetheless written to the temporary
rvi file as provided. All rvi commands should include the colon prefix to the command (e.g. ":SilentMode" not "SilentMode"),
 as this is not added automatically.

Note that this function may not work in all servers, as some more specific setups when invoking the \code{system}
command may be required. In addition, errors may occur if the Raven.exe file does not have permission to execute. This
can be rectified with the \code{run_chmod} parameter set to \code{TRUE}
}
\examples{
\dontrun{
## NOT RUN (data download + runs Raven.exe)
url<-"http://raven.uwaterloo.ca/files/RavenTutorialFiles.zip"
temploc <- tempdir()
destfile<-paste(temploc,"/RavenTutorialFiles.zip",sep="")
download.file(url,destfile)
destdir<-paste(temploc,"/RavenTutorialFiles",sep="")
dir.create(destdir)
unzip(zipfile=destfile,exdir=destdir)
file.remove(destfile)

## check that Raven.exe is downloaded
if (!rvn_download(check=TRUE)) {rvn_download()}

# Irondeqoiut example
rvn_run(indir=paste(destdir,"/Irond",sep=""),
        showoutput=TRUE)

# run in Silent Mode (rvi option)
rvn_run(indir=paste(destdir,"/Irond",sep=""),
        showoutput=TRUE,
        rvi_options=c(":SilentMode"))
}

}
\seealso{
\code{\link{rvn_download}}
}
