% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lookup.R
\name{lookupSecurity}
\alias{lookupSecurity}
\title{Look up symbol from Bloomberg}
\usage{
lookupSecurity(query, yellowkey = c("none", "cmdt", "eqty", "muni", "prfd",
  "clnt", "mmkt", "govt", "corp", "indx", "curr", "mtge"),
  language = c("none", "english", "kanji", "french", "german", "spanish",
  "portuguese", "italian", "chinese_trad", "korean", "chinese_simp", "none_1",
  "none_2", "none_3", "none_4", "none_5", "russian"), maxResults = 20,
  verbose = FALSE, con = defaultConnection())
}
\arguments{
\item{query}{A character variable describing the name of the company; for
certain queries a trailing space may help.}

\item{yellowkey}{A character variable that restricts the asset classes
to search in; one of \dQuote{none}, \dQuote{cmdt}, \dQuote{eqty}, \dQuote{muni},
\dQuote{prfd}, \dQuote{clnt}, \dQuote{mmkt}, \dQuote{govt}, \dQuote{corp},
\dQuote{indx}, \dQuote{curr}, \dQuote{mtge}.}

\item{language}{A character variable denoting the language that the
results will be translated in; one of \dQuote{NONE},
\dQuote{english}, \dQuote{kanji}, \dQuote{french},
\dQuote{german}, \dQuote{spanish}, \dQuote{portuguese},
\dQuote{italian}, \dQuote{chinese_trad}, \dQuote{korean},
\dQuote{chinese_simp}, \dQuote{none_1}, \dQuote{none_2},
\dQuote{none_3}, \dQuote{none_4}, \dQuote{none_5},
\dQuote{russian}}

\item{maxResults}{A integer variable containing a value by which to limit
the search length}

\item{verbose}{A boolean indicating whether verbose operation is
desired, defaults to \sQuote{FALSE}}

\item{con}{A connection object as created by a \code{blpConnect}
call, and retrieved via the internal function
\code{defaultConnection}.}
}
\value{
A data.frame with two columns of the ticker and description of each
match.
}
\description{
This function uses the Bloomberg API to look up tickers and descriptions
given the name of a company.
}
\examples{
\dontrun{
  lookupSecurity("IBM")
  lookupSecurity("IBM", maxResuls=1000)    # appears to be capped at 1000
  lookupSecurity("IBM", "mtge")
  lookupSecurity("IBM ", "mtge")           # trailing space affects query

  ## modify the symbol column (cf issue ticket 215 at GitHub)
  res <- lookupSecurity("IBM")
  res[, "symbol"] <- sub(pattern="^(.+)<(.)(.+)>$", "\\\\1 \\\\U\\\\2\\\\E\\\\3",
                         perl=TRUE, res[, "security"])
  res
}
}
\author{
Kevin Jin and Dirk Eddelbuettel
}
