

\name{get_thermalstrat}
\alias{get_thermalstrat}
\title{
estimate thermal stratification indices
}
\description{
estimates thermal stratification indices, including thermocline depth, gradient, mixed later depth and stratifcation index from daily temperature at depth profiles, as illustrated by Bauer et al. (2015) for archival tagging data. 

}

\usage{
get_thermalstrat(x, dz=20, strat_lim=100, na.rm=FALSE, 
                 show_info=TRUE, Depth_res, all_info=FALSE)
}
 

\arguments{
\item{x}{A list generated by \link{interpolate_TempDepthProfiles}, containing interpolated temperature at depth profiles and their corresponding date and depth vectors:

 $ Data_Source.ID_key:List of 3\cr
  ..$ Temperature_matrix: num\cr
  ..$ Depth             : num\cr 
  ..$ Date              :Date\cr
  ..$ sm                :data.frame\cr  
  .. ..$ Date              :chr\cr
  .. ..$ nrecs            :int\cr
  .. ..$ Depths           :chr\cr

}

\item{dz}{
size of the moving window in meters between which temperature values should be compared for the estimation of the thermocline gradient and depth (by default 20).
}


\item{na.rm}{
whether interpolated temperature at depth profiles with missing values should be treated (default is \code{FALSE}).
}

\item{strat_lim}{
up to which depth (in meters) temperature values should be considered for the estimation of the stratication index (by default 100).
}

\item{Depth_res}{
numeric value, defining the depth resolution at which the temperature data should be interpolated.
}

\item{show_info}{
whether the process of the function run should be indicated (by default TRUE).
}

\item{all_info}{
whether the summary information of the input file should be generated in the output (by default FALSE).
}


}



\value{
a \link{data.frame} composed of 
\describe{
\item{\code{Date}}{a date vector (see input argument \code{x})}
\item{\code{maxDepth_interp}}{the maxmium depth (in meters) of a daily temperature at depth profile to which its interpolation is limitied)}
\item{\code{tgrad}}{the maximum temperature gradient of all possible moving windows of size \code{dz})}
\item{\code{tcline}}{the thermocline depth, defined as the average depth (of the depth range) of the moving window(s) with the maximum temperature gradient \code{tgrad})}
\item{\code{dz}}{size of the moving window in meters between which temperature values were compared}
\item{\code{mld}}{mixed layer depth, defined as the average depth of the first moving window that meets maximum temperature gradient criterium)
}
\item{\code{mld_0.5}}{mixed layer depth, defined as as the depth at which T = SST-0.5 degrees, the temperature criterion of Monterey and Levitus (1997).
}
\item{\code{mld_0.8}}{mixed layer depth, defined as the depth at which T = SST-0.8 degrees, the temperature criterion of Kara et al. (2000, 2003).
}
\item{\code{strat_index}}{stratification index, defined as the standard deviation of all interpolated temperature values up to the depth defined by the argument \code{strat_lim}}
\item{\dots}{
optional columns to be taken from the \code{sm} data.frame of the input list (in case that \code{all_info=TRUE})\describe{
\item{\code{nrecs}}{number of records of the non-interpolated daily temperature at depth profiles}
\item{\code{Depths}}{unique depth records of the non-interpolated daily temperature at depth profiles, seperated by '; '}

}
}
}
}

\seealso{\link{interpolate_TempDepthProfiles}} 


\author{
Robert K. Bauer
}

\references{
Bauer, R., F. Forget and JM. Fromentin (2015) Optimizing PAT data transmission: assessing the accuracy of temperature summary data to estimate environmental conditions. Fisheries Oceanography, 24(6): 533-539, 
\href{http://dx.doi.org/10.1111/fog.12127}{doi: 10.1111/fog.12127}

Kara, A. B., P. A. Rochford, and H. E. Hurlburt (2000). An optimal definition for ocean mixed layer depth. Journal of Geophysical Research, 105:16803-16821, \href{http://dx.doi.org/10.1029/2000JC900072}{doi: 10.1029/2000JC900072}

Kara, A. B., P. A. Rochford, and H. E. Hurlburt (2003) Mixed layer depth variability over the global ocean. Journal of Geophysical Research, 108:3079, \href{http://dx.doi.org/10.1029/2000JC000736}{doi: 10.1029/2000JC000736}

Monterey, G., and S. Levitus (1997) Seasonal variability of mixed layer depth for the world ocean. NOAA Atlas NESDIS 14, U. S. Govt. Printing Office.

}

\examples{
#### example 1) run on PDT file:
## step I) read sample PDT data file:
path <- system.file("example_files",package="RchivalTag")
PDT <- read_PDT("104659-PDTs.csv",folder=path)
head(PDT)
# 
# ## step II) interpolate average temperature fields (MeanPDT) from PDT file:
# m <- interpolate_PDTs(PDT)
# str(m)
# m$sm
# 
# ## step III) calculate thermal stratifcation indicators per day (and tag):
# get_thermalstrat(m, all_info = TRUE)
# get_thermalstrat(m, all_info = FALSE)
# 
# 
# #### example 2) run on time series data:
# ## step I) read sample time series data file:
# DepthTempTS <- read.table(system.file("example_files/104659-Series.csv",
#                                       package="RchivalTag"),header = TRUE,sep=',')
# DepthTempTS$date <- as.Date(DepthTempTS$Day,"\%d-\%b-\%Y")
# head(DepthTempTS)
# 
# 
# ## step Ib) bin temperature data on 10m depth bins 
# ##          to increase later estimate accuracy (see Bauer et al. 2015):
# # DepthTempTS_binned <- bin_TempTS(DepthTempTS,res=10)
# 
# ## step II) interpolate average temperature fields (MeanTemp) from binned data:
# m <- interpolate_TempDepthProfiles(DepthTempTS)
# # m <- interpolate_PDTs(DepthTempTS_binned)
# str(m)
# m$sm
# 
# ## step III) calculate thermal stratifcation indicators per day (and tag):
# get_thermalstrat(m, all_info = TRUE)
# get_thermalstrat(m, all_info = FALSE)


}

