% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleCompute.R
\name{computeEM}
\alias{computeEM}
\title{Expectation-Maximization clustering}
\usage{
computeEM(
  x,
  K = 0,
  K.max = 20,
  kmeans.variance.min = 0.95,
  graph = F,
  Mclust.options = list()
)
}
\arguments{
\item{x}{matrix of raw data (point by line).}

\item{K}{number of clusters. If K=0 (default), this number is automatically computed thanks to the Elbow method.}

\item{K.max}{maximal number of clusters (K.Max=20 by default).}

\item{kmeans.variance.min}{elbow method cumulative explained variance > criteria to stop K-search.}

\item{graph}{boolean: if TRUE, figures for total of within-class inertia and explained variance are plotted.}

\item{Mclust.options}{list of default parameters values for the function Mclust.}
}
\value{
res.EM results obtained from Mclust algorithm.
}
\description{
Perform Expectation-Maximization clustering, dealing with the number of clusters K, automatically or not.
}
\details{
computeEM performs Expectation-Maximization clustering, dealing with the number of clusters K, automatically or not
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))
tf <- tempfile()
write.table(dat, tf, sep=",", dec=".")

x <- importSample(file.features=tf, dir.save=tempdir())
res.em <- computeEM(x$features$initial$x, K=0, graph=TRUE)
plot(dat[,1], dat[,2], type = "p", xlab = "x", ylab = "y", 
col = res.em$classification, main = "EM clustering")


}
\seealso{
\code{\link{computeUnSupervised}}, \code{\link{computeKmeans}}
}
\keyword{internal}
