% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleBuilding.R
\name{loadPreviousRes}
\alias{loadPreviousRes}
\title{Previous clustering results loading}
\usage{
loadPreviousRes(data.sample, noise.cluster = "Noise")
}
\arguments{
\item{data.sample}{sample object.}

\item{noise.cluster}{character name of the cluster "Noise".}
}
\value{
data.sample updated with previous clustering results.
}
\description{
Load previous clustering results obtained from previous analyses.
}
\details{
loadPreviousRes loads previous results obtained from previous analyses.
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))
tf <- tempfile()
write.table(dat, tf, sep=",", dec=".")

x <- importSample(file.features=tf, dir.save=tempdir())
loadPreviousRes(x)


}
\keyword{internal}
