% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleClustering.R
\name{saveCalcul}
\alias{saveCalcul}
\title{Object saving}
\usage{
saveCalcul(filename.rdata, dat, dir)
}
\arguments{
\item{filename.rdata}{character vector specifying the path and the name of the rdata file.}

\item{dat}{object to save.}

\item{dir}{character vector specifying the directory where to save the rdata file.}
}
\value{
RDS file containing calculation.
}
\description{
Save object created after calculation in a csv file.
}
\details{
saveCalcul saves object created after calculation in a csv file
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))
tf1 <- tempfile()
write.table(dat, tf1, sep=",", dec=".")

x <- importSample(file.features=tf1)
res.pca <- computePcaSample(x)

tf2 <- tempfile()
saveCalcul(basename(tf2), res.pca$pca, dirname(tf2))


}
