% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleCompute.R
\name{removeZeros}
\alias{removeZeros}
\title{Zeros replacement}
\usage{
removeZeros(x, threshold = .Machine$double.eps, positive = FALSE)
}
\arguments{
\item{x}{numeric matrix or data.frame of raw data (points by line).}

\item{threshold}{numeric value; must be positive.}

\item{positive}{boolean: if TRUE, zeros-like values are replaced by +threshold}
}
\value{
x numeric matrix or data.frame of raw data (points by line), with no zeros.
}
\description{
Replace all zeros-like values (in [-threshold,+threshold])
by +threshold (if positive values are required) or +/-threshold.
}
\details{
removeZeros replaces all zeros-like values (in [-threshold,+threshold])
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))
tf <- tempfile()
write.table(dat, tf, sep=",", dec=".")
x <- importSample(file.features=tf, dir.save=tempdir())

res <- removeZeros(x$features$initial$x)  


}
\keyword{internal}
