# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' const_cost
#' 
#' Calculate cost of using mean of points to estimate other points in interval.
#' Zero indexed.
#' 
#' @param y NumericVector, values to group in order.
#' @param w NumericVector, weights.
#' @param min_seg positive integer, minimum segment size.
#' @param i integer, first index (inclusive).
#' @param j integer, j>=i last index (inclusive);
#' @return scalar, const cost of [i,...,j] interval (inclusive).
#' 
#' @keywords internal
#' 
#' @examples
#' 
#' const_cost(c(1, 1, 2, 2), c(1, 1, 1, 1), 1, 0, 3)
#' 
#' @export
const_cost <- function(y, w, min_seg, i, j) {
    .Call('_RcppDynProg_const_cost', PACKAGE = 'RcppDynProg', y, w, min_seg, i, j)
}

#' const_costs
#' 
#' Built matrix of interval costs for held-out means.
#' One indexed.
#' 
#' @param y NumericVector, values to group in order.
#' @param w NumericVector, weights.
#' @param min_seg positive integer, minimum segment size.
#' @param indices IntegerVector, order list of indices to pair.
#' @return xcosts NumericMatix, for j>=i xcosts(i,j) is the cost of partition element [i,...,j] (inclusive).
#' 
#' 
#' @examples
#' 
#' const_costs(c(1, 1, 2, 2), c(1, 1, 1, 1), 1, 1:4)
#' 
#' @export
const_costs <- function(y, w, min_seg, indices) {
    .Call('_RcppDynProg_const_costs', PACKAGE = 'RcppDynProg', y, w, min_seg, indices)
}

#' lin_cost
#' 
#' Calculate cost of using linear model fit on points to estimate other points in the interval.
#' Zero indexed.
#' 
#' @param x NumericVector, x-coords of values to group.
#' @param y NumericVector, values to group in order.
#' @param w NumericVector, weights.
#' @param min_seg positive integer, minimum segment size.
#' @param i integer, first index (inclusive).
#' @param j integer, j>=i last index (inclusive);
#' @return scalar, linear cost of [i,...,j] interval (inclusive).
#' 
#' @keywords internal
#' 
#' @examples
#' 
#' lin_cost(c(1, 2, 3, 4), c(1, 2, 2, 1), c(1, 1, 1, 1), 1, 0, 3)
#' 
#' @export
lin_cost <- function(x, y, w, min_seg, i, j) {
    .Call('_RcppDynProg_lin_cost', PACKAGE = 'RcppDynProg', x, y, w, min_seg, i, j)
}

#' lin_costs
#' 
#' Built matrix of interval costs for held-out linear models.
#' One indexed.
#' 
#' @param x NumericVector, x-coords of values to group.
#' @param y NumericVector, values to group in order.
#' @param w NumericVector, weights.
#' @param min_seg positive integer, minimum segment size.
#' @param indices IntegerVector, ordered list of indices to pair.
#' @return xcosts NumericMatix, for j>=i xcosts(i,j) is the cost of partition element [i,...,j] (inclusive).
#' 
#' @examples
#' 
#' lin_costs(c(1, 2, 3, 4), c(1, 2, 2, 1), c(1, 1, 1, 1), 1, 1:4)
#' 
#' @export
lin_costs <- function(x, y, w, min_seg, indices) {
    .Call('_RcppDynProg_lin_costs', PACKAGE = 'RcppDynProg', x, y, w, min_seg, indices)
}

#' solve_interval_partition interval partition problem.
#' 
#' Solve a for a minimal cost partition of the integers [1,...,nrow(x)] problem where for j>=i x(i,j).
#' is the cost of choosing the partition element [i,...,j]. 
#' Returned solution is an ordered vector v of length k where: v[1]==1, v[k]==nrow(x)+1, and the 
#' partition is of the form [v[i], v[i+1]) (intervals open on the right).
#' 
#' @param x NumericMatix, for j>=i x(i,j) is the cost of partition element [i,...,j] (inclusive).
#' @param kmax int, maximum number of segments in solution. 
#' @return dynamic program solution.
#' 
#' @examples
#' 
#' costs <- matrix(c(1.5, NA ,NA ,1 ,0 , NA, 5, -1, 1), nrow = 3)
#' solve_interval_partition(costs, nrow(costs))
#'
#' @export
solve_interval_partition <- function(x, kmax) {
    .Call('_RcppDynProg_solve_interval_partition', PACKAGE = 'RcppDynProg', x, kmax)
}

#' xlin_fits
#' 
#' Calculate out of sample linear fit predictions.
#' Zero indexed.
#' 
#' @param x NumericVector, x-coords of values to group (length>=2).
#' @param y NumericVector, values to group in order.
#' @param w NumericVector, weights (positive).
#' @param i integer, first index (inclusive).
#' @param j integer, j>=i+2 last index (inclusive);
#' @return  vector of predictions.
#' 
#' @keywords internal
#' 
#' @examples
#' 
#' xlin_fits(c(1, 2, 3, 4), c(1, 2, 2, 1), c(1, 1, 1, 1), 0, 3)
#' 
#' @export
xlin_fits <- function(x, y, w, i, j) {
    .Call('_RcppDynProg_xlin_fits', PACKAGE = 'RcppDynProg', x, y, w, i, j)
}

