% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mse}
\alias{mse}
\title{Mean Squared Error loss of a factor model}
\usage{
mse(A, w, d, h, mask_zeros = FALSE)
}
\arguments{
\item{A}{Sparse matrix of features x samples, class "Matrix::dgCMatrix"}

\item{w}{dense matrix of class \code{matrix} with factors (columns) by features (rows)}

\item{d}{diagonal scaling vector of rank length}

\item{h}{dense matrix of class \code{matrix} with samples (columns) by factors (rows)}

\item{mask_zeros}{handle zeros as missing values}
}
\value{
mean squared error of the factorization model
}
\description{
MSE of factor models \code{w} and \code{h} given sparse matrix \eqn{A}
}
\details{
Mean squared error of a matrix factorization of the form \eqn{A = wdh} is given by \deqn{\frac{\sum_{i,j}{(A - wdh)^2}}{ij}} where \eqn{i} and \eqn{j} are the number of rows and columns in \eqn{A}.

Thus, this function simply calculates the cross-product of \eqn{wh} or \eqn{wdh} (if \eqn{d} is specified),
subtracts that from \eqn{A}, squares the result, and calculates the mean of all values.

If no diagonal scaling vector is present in the model, input \code{d = rep(1, k)} where \code{k} is the rank of the model.

\strong{Parallelization.} Calculation of mean squared error is performed in parallel across columns in \code{A} using the number of threads set by \code{\link{setRcppMLthreads}}.
By default, all available threads are used, see \code{\link{getRcppMLthreads}}.
}
\examples{
\dontrun{
library(Matrix)
A <- Matrix::rsparsematrix(1000, 1000, 0.1)
model <- nmf(A, k = 10, tol = 0.01)
c_mse <- mse(A, model$w, model$d, model$h)
R_mse <- mean((A - model$w \%*\% Diagonal(x = model$d) \%*\% model$h)^2)
all.equal(c_mse, R_mse)
}
}
\author{
Zach DeBruine
}
