% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{movCount}
\alias{movCount}
\alias{movCountr}
\title{Moving Count}
\usage{
movCount(vec, n = 1L, ss = 1L, na_rm = FALSE, sizeD = FALSE,
  align = "left")

movCountr(vec, n = 1L, ss = 1L, na_rm = FALSE, sizeD = FALSE)
}
\arguments{
\item{vec}{A numeric vector.}

\item{n}{An integer: moving window size, with 1 as default}

\item{ss}{An integer: step size, only calculating at points with an equal distance \emph{ss}.
Namely, there are \emph{ss-1} number between each two 'consecutive' points}

\item{na_rm}{logical. Should missing values (including NaN) be removed?}

\item{sizeD}{logical. Only applied when \emph{ss > 1}, it decides whether to get a result of 
smaller size. If \eqn{sizeD = T}, \emph{align} does not affect the output.}

\item{align}{A string denotes how to align the moving average, three options: 
"left", "middle", "right"}
}
\value{
This function returns a vector whose length is the same as that of \emph{vec} or is 
\code{\link[base]{ceiling}}\eqn{((L - n + 1)/ss)}, (when \eqn{sizeD = T}), where \eqn{L} is the 
length of \eqn{vec}.
}
\description{
This function returns a moving count of the given vector.
}
\details{
This function counts the number of non-missing values for each moving window. It is 
especially designed for \emph{vec} vector with missing values. Otherwise, it will return a trivial 
vector with all elements \emph{n}.
}
\section{Functions}{
\itemize{
\item \code{movCountr}: An function equivalent to \code{movCount(..., align = "right")}
}}

\examples{
movCount(c(1, 4, 3, NA, 8), 2, na_rm = TRUE)
movCount(c(1, 4, 3, NA, 8), 2, na_rm = TRUE, align = 'right')
movCountr(c(1, 4, 3, NA, 8), 2, na_rm = TRUE)
movCount(c(1, 4, 3, NA, NA), 2, na_rm = TRUE)
}
