% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/INMF.R
\name{inmf}
\alias{inmf}
\title{Perform Integrative Non-negative Matrix Factorization}
\usage{
inmf(
  objectList,
  k = 20,
  lambda = 5,
  niter = 30,
  nCores = 2,
  Hinit = NULL,
  Vinit = NULL,
  Winit = NULL,
  verbose = FALSE
)
}
\arguments{
\item{objectList}{list of input datasets. List elements should all be of the
same class. Viable classes include: matrix, dgCMatrix,
\link{H5Mat}, \link{H5SpMat}.}

\item{k}{Integer. Inner dimensionality to factorize the datasets into.
Default \code{20}.}

\item{lambda}{Regularization parameter. Larger values penalize
dataset-specific effects more strongly (i.e. alignment should increase as
\code{lambda} increases). Default \code{5}.}

\item{niter}{Integer. Total number of block coordinate descent iterations to
perform. Default \code{30}.}

\item{nCores}{The number of parallel tasks that will be spawned.
Default \code{2}}

\item{Hinit}{Initial values to use for \eqn{H} matrices. A list object where
each element is the initial \eqn{H} matrix of each dataset. Each should be
dense matrix of size \eqn{n_i \times k}. Default \code{NULL}.}

\item{Vinit}{Similar to \code{Hinit}, but each should be of size
\eqn{m \times k}.}

\item{Winit}{Initial values to use for \eqn{W} matrix. A matrix object of
size \eqn{m \times k}. Default \code{NULL}.}

\item{verbose}{Logical scalar. Whether to show information and progress.
Default \code{FALSE}.}
}
\value{
A list of the following elements:
\itemize{
 \item{\code{H} - a list of result \eqn{H_i} matrices of size
 \eqn{n_i \times k}}
 \item{\code{V} - a list of result \eqn{V_i} matrices}
 \item{\code{W} - the result \eqn{W} matrix}
 \item{\code{objErr} - the final objective error value.}
}
}
\description{
Performs integrative non-negative matrix factorization (iNMF) (J.D. Welch,
2019) to return factorized \eqn{H}, \eqn{W}, and \eqn{V} matrices. The
objective function is stated as

\deqn{\arg\min_{H\ge0,W\ge0,V\ge0}\sum_{i}^{d}||E_i-(W+V_i)Hi||^2_F+
\lambda\sum_{i}^{d}||V_iH_i||_F^2}

where \eqn{E_i} is the input non-negative matrix of the \eqn{i}'th dataset,
\eqn{d} is the total number of datasets. \eqn{E_i} is of size
\eqn{m \times n_i} for \eqn{m} features and \eqn{n_i} sample points,
\eqn{H_i} is of size \eqn{k \times n_i}, \eqn{V_i} is of size
\eqn{m \times k}, and \eqn{W} is of size \eqn{m \times k}.

\code{inmf} optimizes the objective with ANLS strategy, while
\code{\link{onlineINMF}} optimizes the same objective with an online learning
strategy.
}
\examples{
library(Matrix)
set.seed(1)
result <- inmf(list(ctrl.sparse, stim.sparse), k = 10, niter = 10, verbose = FALSE)
}
\references{
Joshua D. Welch and et al., Single-Cell Multi-omic Integration
Compares and Contrasts Features of Brain Cell Identity, Cell, 2019
}
\author{
Yichen Wang
}
