% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rcss.R
\name{printRcss}
\alias{printRcss}
\title{Display properties encoded in an Rcss object}
\usage{
printRcss(Rcss, selector = NULL, verbose = FALSE)
}
\arguments{
\item{Rcss}{style sheet object}

\item{selector}{character string with name of selector to print}

\item{verbose}{logical. If TRUE, function prints all information
about the selector, including subclasses. If FALSE, function omits
detailed information about subclasses.}
}
\description{
Display properties encoded in an Rcss object, including any subclasses.
}
\examples{

# define a custom style
custom.style <- Rcss(text="points { pch:2; } points.A { pch: 3; }")

# printing details for a selector, concise and verbose
printRcss(custom.style, "points")
printRcss(custom.style, "points", verbose=TRUE)

}
