% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadSNOMED.R
\name{loadREADMAPS}
\alias{loadREADMAPS}
\title{Load mappings from Read to SNOMED CT into an R data.table}
\usage{
loadREADMAPS(
  not_assured_rcsctmap_uk,
  not_assured_rctermsctmap_uk,
  assured_ctv3sctmap2_uk
)
}
\arguments{
\item{not_assured_rcsctmap_uk}{File containing Read 2 codes
mapped to SNOMED CT, in file:
'Not Clinically Assured/rcsctmap_uk_20200401000001.txt'}

\item{not_assured_rctermsctmap_uk}{File containing Read 2 terms
mapped to SNOMED CT, in file:
'Not Clinically Assured/rctermsctmap_uk_20200401000001.txt'}

\item{assured_ctv3sctmap2_uk}{File containing CTV3 concepts
and terms mapped to SNOMED CT, in file:
'Clinically Assured/ctv3sctmap2_uk_20200401000001.txt'}
}
\value{
A data.table with columns conceptId, read2_code,
  ctv3_concept, ctv3_termid
}
\description{
Creates a mapping table derived from NHS Digital
Data Migration distribution. These tables are available from
the Technology Reference Update Distribution:
\url{https://isd.digital.nhs.uk/trud/user/guest/group/0/pack/9/subpack/9/releases}
}
\details{
The final release was in April 2020. The mapping tables are
intended for converting entires in clinical records from
Read Version 2 (Read 2) to SNOMED CT, and Clinical Terms
Version 3 (CTV3) to SNOMED CT.

These maps can be used for converting SNOMED CT codelists into
Read 2 or CTV3 format for running queries, such as to characterise
patient phenotypes or identify patient populations for research.
They cannot be used in the reverse direction (to map a Read 2/CTV3
codelist to SNOMED CT) because some of the SNOMED CT terms will
be missed out, and the list will be incomplete.

This function uses the following three mapping files:
\itemize{
   \item{not_assured_rcsctmap_uk}{ File containing Read 2 codes
     mapped to SNOMED CT, in file:
     'Not Clinically Assured/rcsctmap_uk_20200401000001.txt'}
   \item{not_assured_rctermsctmap_uk}{ File containing Read 2 terms
     mapped to SNOMED CT, in file:
     'Not Clinically Assured/rctermsctmap_uk_20200401000001.txt'}
   \item{assured_ctv3sctmap2_uk}{ File containing CTV3 concepts
     and terms mapped to SNOMED CT, in file:
     'Clinically Assured/ctv3sctmap2_uk_20200401000001.txt'}
}

The output data.table has the following columns:
\itemize{
  \item{conceptId}{ integer64: SNOMED CT conceptId (primary key)} 
  \item{read2_code}{ list: character list of 7-character Read 2 codes}
  \item{read2_term}{ list: character list of Read 2 terms}
  \item{ctv3_concept}{ list: character list of CTV3 concept codes}
  \item{ctv3_termid}{ list: character list of CTV3 term description codes}
}
}
\seealso{
READMAPS, getMaps, loadSNOMED
}
