% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_ISOMAP.R
\name{do.isomap}
\alias{do.isomap}
\title{Isometric Feature Mapping}
\usage{
do.isomap(X, ndim = 2, type = c("proportion", 0.1), symmetric = "union",
  weight = TRUE, preprocess = "center")
}
\arguments{
\item{X}{an \code{(n-by-p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{type}{a vector of neighborhood graph construction. Following types are supported;
\code{c("knn",k)}, \code{c("enn",radius)}, and \code{c("proportion",ratio)}.
Default is \code{c("proportion",0.1)}, connecting about 1/10 of nearest data points
among all data points. See also \code{\link{aux.graphnbd}} for more details.}

\item{symmetric}{one of \code{"intersect"}, \code{"union"} or \code{"asymmetric"} is supported. Default is \code{"union"}. See also \code{\link{aux.graphnbd}} for more details.}

\item{weight}{\code{TRUE} to perform Isomap on weighted graph, or \code{FALSE} otherwise.}

\item{preprocess}{an additional option for preprocessing the data.
Default is ``center'' and other methods of ``decorrelate'', or ``whiten''
are supported. See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \code{(n-by-ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
\code{do.isomap} is an efficient implementation of a well-known \emph{Isomap} method
by Tenenbaum et al (2000). Its novelty comes from applying classical multidimensional
scaling on nonlinear manifold, which is approximated as a graph.
}
\examples{
## generate data
## in order to pass CRAN pretest, n is set to be small.
X <- aux.gensamples(n=28)

## 1. connecting 10\% of data for graph construction.
output1 <- do.isomap(X,ndim=2,type=c("proportion",0.10))

## 2. constructing 25\%-connected graph
output2 <- do.isomap(X,ndim=2,type=c("proportion",0.25))

## 3. constructing 25\%-connected with binarization
output3 <- do.isomap(X,ndim=2,type=c("proportion",0.25),weight=FALSE)

## Visualize three different projections
par(mfrow=c(1,3))
plot(output1$Y[,1],output1$Y[,2],main="5\%")
plot(output2$Y[,1],output2$Y[,2],main="10\%")
plot(output3$Y[,1],output3$Y[,2],main="10\%+Binary")



}
\references{
Tenenbaum, J.B., de Silva, V., and Langford, J.C. (2000) \emph{A Global
Geometric Framework for Nonlinear Dimensionality Reduction}. Science Vol.290:2319-2323.
}
\author{
Kisung You
}
