% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_DAGDNE.R
\name{do.dagdne}
\alias{do.dagdne}
\title{Double-Adjacency Graphs-based Discriminant Neighborhood Embedding}
\usage{
do.dagdne(
  X,
  label,
  ndim = 2,
  numk = max(ceiling(nrow(X)/10), 2),
  preprocess = c("center", "scale", "cscale", "decorrelate", "whiten")
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations.}

\item{label}{a length-\eqn{n} vector of data class labels.}

\item{ndim}{an integer-valued target dimension.}

\item{numk}{the number of neighboring points for k-nn graph construction.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center". See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Doublue Adjacency Graphs-based Discriminant Neighborhood Embedding (DAG-DNE) is a
variant of DNE. As its name suggests, it introduces two adjacency graphs for
homogeneous and heterogeneous samples accordaing to their labels.
}
\examples{
## load iris data
data(iris)
X     = as.matrix(iris[,1:4])
label = as.factor(iris$Species)

## try different numbers for neighborhood size
out1 = do.dagdne(X, label, numk=5)
out2 = do.dagdne(X, label, numk=10)
out3 = do.dagdne(X, label, numk=25)

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, main="nbd size=5", col=label, pch=19, cex=0.5)
plot(out2$Y, main="nbd size=10",col=label, pch=19, cex=0.5)
plot(out3$Y, main="nbd size=25",col=label, pch=19, cex=0.5)
par(opar)

}
\references{
\insertRef{ding_double_2015}{Rdimtools}
}
\seealso{
\code{\link{do.dne}}
}
\author{
Kisung You
}
\concept{linear_methods}
