% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v1_feature_PFA.R
\name{do.pfa}
\alias{do.pfa}
\title{Principal Feature Analysis}
\usage{
do.pfa(X, ndim = 2, ...)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension (default: 2).}

\item{...}{extra parameters including \describe{
\item{cor}{mode of eigendecomposition. \code{FALSE} for decomposing the
empirical covariance matrix and \code{TRUE} uses the correlation matrix
(default: \code{FALSE}).}
\item{preprocess}{an additional option for preprocessing the data.
See also \code{\link{aux.preprocess}} for more details (default: \code{"center"}).}
}}
}
\description{
Principal Feature Analysis \insertCite{lu_2007_FeatureSelectionUsing}{Rdimtools}
adopts an idea from the celebrated PCA for unsupervised feature selection.
}
\examples{
\donttest{
## use iris data
## it is known that feature 3 and 4 are more important.
data(iris)
set.seed(100)
subid    <- sample(1:150, 50)
iris.dat <- as.matrix(iris[subid,1:4])
iris.lab <- as.factor(iris[subid,5])

## compare with other methods
out1 = do.pfa(iris.dat)
out2 = do.lscore(iris.dat)
out3 = do.fscore(iris.dat, iris.lab)

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, pch=19, col=iris.lab, main="Principal Feature Analysis")
plot(out2$Y, pch=19, col=iris.lab, main="Laplacian Score")
plot(out3$Y, pch=19, col=iris.lab, main="Fisher Score")
par(opar)
}

}
\references{
\insertAllCited{}
}
\concept{feature_methods}
