% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ESW.r
\name{ESW}
\alias{ESW}
\title{Line transect Effective Strip Width (ESW)}
\usage{
ESW(obj, newdata)
}
\arguments{
\item{obj}{An estimated detection function object.  An estimated detection 
function object has class 'dfunc', and is usually produced by a call to 
\code{dfuncEstim}. The estimated detection function may optionally contain 
a \eqn{g(0)} component that specifies detection probability 
on the transect.  If no \eqn{g(0)} component is found, \eqn{g(0)} =
1 is assumed.}

\item{newdata}{A data frame containing new values of 
the covariates at which ESW's are sought. If NULL or missing and 
\code{obj} contains covariates, the  
covariates stored in \code{obj} are used. See \bold{Value} section.}
}
\value{
If \code{newdata} is not missing and not NULL and 
covariates are present in \code{obj}, the returned value is 
a vector of ESW values associated with covariates in the 
distance function and equal in length to the number of rows in \code{newdata}. 
If \code{newdata} is missing or NULL and covariates are present
in \code{obj}, an ESW vector with length equal to 
the number of detections in \code{obj$detections} is returned. 

If \code{obj} does not contain covariates, \code{newdata} is ignored and 
a scalar equal to the (constant) effective strip width for all 
detections is returned.
}
\description{
Returns effective strip width (ESW) from an estimated 
  line transect detection
  functions. This function applies only to line transect information.
  Function \code{EDR} is for point transect data. Function 
  \code{effectiveDistance} accepts either point or line transect data.
}
\details{
Effective strip width (ESW) of a distance function is its
  integral. That is, ESW is the area under the distance function from its
  left-truncation limit (\code{obj$w.lo}) to its right-truncation limit
  (\code{obj$w.hi}). \if{latex}{In mathematical notation, \deqn{ESW =
  \int_{w.lo}^{w.hi} g(x)dx,} where \eqn{g(x)} is the height of the distance
  function at distance \eqn{x}, and \eqn{w.lo} and \eqn{w.hi} are the lower
  and upper truncation limits used during the survey.  }
  
  If detection does not decline with distance, area under the detection 
  function is the entire half-width of 
  the strip transect (i.e., \code{obj$w.hi - obj$w.lo}).  
  In this case density is the number sighted targets 
  divided by area surveyed, where area surveyed is 
  \code{obj$w.hi-obj$w.lo} times
  total length of transects.
  
  When detection declines with distance, less than the total half-width is
  \emph{effectively} covered. In this case, Buckland \emph{et al.} (1993) show that the
  denominator of the density estimator is total length of 
  surveyed transects times area under the detection function (i.e., this
  integral). By analogy with the non-declining detection case, ESW is the 
  transect half-width that observers \emph{effectively}
  cover. In other words, if ESW = X, the study 
  effectively covers the same area as a study with non-declining detection out to a
  distance of X.
  
  \emph{A technical consideration}: Rdistance uses the trapezoid rule to numerically 
  integrate under the distance
  function from \code{obj$w.lo} to \code{obj$w.hi}. Two-hundred
  trapezoids are used in the approximation to speed calculations.  In some
  rare cases, two hundred trapezoids may not be enough.  In these cases, 
  users should modify this function's code and bump \code{seq.length} to 
  a value greater than 200.
}
\examples{
# Load example sparrow data (line transect survey type)
data(sparrowDetectionData)

dfunc <- dfuncEstim(formula=dist~1
                  , detectionData = sparrowDetectionData)

# Compute effective strip width (ESW)
ESW(dfunc)

}
\references{
Buckland, S.T., Anderson, D.R., Burnham, K.P. and Laake, J.L.
  1993. \emph{Distance Sampling: Estimating Abundance of Biological
  Populations}. Chapman and Hall, London.
}
\seealso{
\code{\link{dfuncEstim}}, \code{\link{EDR}}, 
\code{\link{effectiveDistance}}
}
\keyword{modeling}
