% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oneBsIter.R
\name{oneBsIter}
\alias{oneBsIter}
\title{Computations for one bootstrap iteration}
\usage{
oneBsIter(
  indexDf,
  key,
  data,
  formula,
  likelihood,
  w.lo,
  w.hi,
  expansions,
  series,
  x.scl,
  g.x.scl,
  outputUnits,
  warn,
  area,
  propUnitSurveyed,
  pb,
  plot.bs,
  plotCovValues,
  asymptoticSE = FALSE
)
}
\arguments{
\item{indexDf}{A data frame containing row indices to use 
for subsetting the rows of \code{data}. The actual indices are 
in column \code{rowIndex}.}

\item{key}{A data frame containing the current id of the 
BS iteration.  This is included for compatibility with 
\code{dplyr::group_modify}, but it is not used internally.
The original non-resampled data have \code{key == "Original"}.}

\item{data}{An Rdistance nested data frame containing 
the data to bootstrap resample.  Rows of this data frame, 
equating to transects, are sampled using the indices in 
\code{indexDf$rowIndex}.}

\item{formula}{A standard formula object.  For example, \code{dist ~ 1}, 
\code{dist ~ covar1 + covar2}). The left-hand side (before \code{~})
is the name of the vector containing off-transect or radial detection distances.  
The right-hand side contains the names of covariate 
vectors to fit in the detection
function, and potentially group sizes. Group sizes are specified 
by including \code{+ groupsize(<variable>)} in the RHS 
(see 'Group Sizes' section).
Covariates can be either detection level 
or transect level and can appear in  \code{data} or exist in the 
global working environment. Regular R scoping 
rules apply.}

\item{likelihood}{String specifying the likelihood to fit. Built-in 
likelihoods at present are "halfnorm", "hazrate", and "negexp".}

\item{w.lo}{Lower or left-truncation limit of the distances in distance data. 
This is the minimum possible off-transect distance. Default is 0.  If 
\code{w.lo} is greater than 0, it must have measurement units. 
See \code{help(unitHelpers)} for assistance assigning units.}

\item{w.hi}{Upper or right-truncation limit of the distances 
in \code{dist}. This is the maximum off-transect distance that 
could be observed. If unspecified (i.e., NULL), 
right-truncation is set to the maximum of the observed 
distances.  If \code{w.hi} is specified, it must have  
measurement units.  
See \code{help(unitHelpers)} for assistance assigning units.}

\item{expansions}{A scalar specifying the number of terms 
in \code{series} to compute. Depending on the series, 
this could be 0 through 5.  The default of 0 equates 
to no expansion terms of any type.  No expansion terms 
are allowed (i.e., \code{expansions} is forced to 0) if 
covariates are present in the detection function 
(i.e., right-hand side of \code{formula} includes
something other than \code{1}).}

\item{series}{If \code{expansions} > 0, this string 
specifies the type of expansion to use. Valid values at 
present are 'simple', 'hermite', and 'cosine'.}

\item{x.scl}{The x coordinate (a distance) at which the 
detection function will be scaled.  \code{g.x.scl} can be a distance
or the string "max".  
When \code{x.scl} is specified (i.e., not 0 or "max"), it must have measurement 
units assigned. 
See \code{help(unitHelpers)} for assistance assigning units.}

\item{g.x.scl}{Height of the distance function at coordinate \code{x}. 
The distance function 
will be scaled so that g(\code{x.scl}) = \code{g.x.scl}. 
If \code{g.x.scl} is not 
a data frame, it must be a numeric value (vector of length 1) 
between 0 and 1.}

\item{outputUnits}{A string specifying the symbolic measurement 
units for results. Valid units are listed in \code{units::valid_udunits()}.
The strings for common distance symbolic units are: 
"m" - meters, "ft" - feet, "cm" - centimeters, "mm" - 
millimeters, "mi" - miles, "nmile" - 
nautical miles ("nm" is nano meters), "in" - inches, 
"yd" - yards, "km" - kilometers, "fathom" - fathoms, 
"chains" - chains, and "furlong" - furlongs.  
If \code{outputUnits} is unspecified (NULL),
output units will be the same as those on 
distances in \code{data}.}

\item{warn}{A logical scalar specifying whether to issue 
an R warning if the estimation did not converge or if one 
or more parameter estimates are at their boundaries.  
For estimation, \code{warn} should generally be left at
its default value of \code{TRUE}.  When computing bootstrap 
confidence intervals, setting \code{warn = FALSE} 
turns off annoying warnings when an iteration does 
not converge.  Regardless of \code{warn}, after 
completion all messages about 
convergence and boundary conditions are printed 
by \code{print.dfunc}, \code{print.abund}, and 
\code{plot.dfunc}.}

\item{area}{A scalar containing the total area of inference. Usually, this is 
study area size.  If \code{area} is NULL (the default), 
\code{area} will be set to 1 square unit of the output units and density estimates
will be produced. 
If \code{area} is not NULL, it must have measurement units 
assigned by the \code{units} package. 
The units on \code{area} must be convertible
to squared output units. Units 
on \code{area} must be two-dimensional. 
For example, if output units are "foo", 
units on area must be convertible to "foo^2" by the \code{units}
package. Units of "km^2", "cm^2", "ha", "m^2", "acre", "mi^2", and several
others are acceptable.}

\item{propUnitSurveyed}{A scalar or vector of real numbers between 0 and 1.
The proportion of the default sampling unit that 
  was surveyed.  If both sides of line transects were observed, 
  \code{propUnitSurveyed}
  = 1.  If only a single side of line transects were observed, set 
  \code{propUnitSurveyed} = 0.5. For point transects, this should be set to 
  the proportion of each circle that was observed. Length must either be
  1 or the total number of transects in \code{x}.}

\item{pb}{A progress bar created with \code{progress::progress_bar$new()}.}

\item{plot.bs}{Logical. Whether to plot bootstrap estimate of detection function.
A plot must already exist because this uses \code{lines}.}

\item{plotCovValues}{Data frame containing values of covariates to plot, 
if \code{plot.bs} is TRUE.}

\item{asymptoticSE}{Logical variable for whether to calculate 
asymptotic standard errors. The default (TRUE) estimates an
asymptotic variance-covariance matrix for parameters based on the 
likelihood's Hessian (2nd derivative). If maximization 
has been performed by Nlminb or HookesJeeves, the asymptotic 
Hessian is estimated using numeric second deriviatives 
of the likelihood at the maximum likelihood solution. If 
maximization was performed by Optim, the last Hessian of 
the maximization is returned 
by Optim and used
(see \code{\link{varcovarEstim}} and \code{\link{secondDeriv}}). 
Asymptotic standard errors will not be estimated if 
\code{asymptoticSE = FALSE}. If not estimated, 
bootstrap iterations will run faster because the numeric Hessian, 
which is discarded during bootstrapping,
will not be calculated every iteration.}
}
\value{
A data frame containing density and abundance 
and other relevant statistics for 
one iteration of the bootstrap.
}
\description{
An internal (un-exported) function to perform density and 
abundance calculations on one iteration of the bootstrap.
}
