/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.misc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.misc.OrderedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graph {
    protected Map<Object, Node> nodes = new HashMap<Object, Node>();

    public void addEdge(Object a, Object b) {
        Node a_node = this.getNode(a);
        Node b_node = this.getNode(b);
        a_node.addEdge(b_node);
    }

    protected Node getNode(Object a) {
        Node existing = this.nodes.get(a);
        if (existing != null) {
            return existing;
        }
        Node n = new Node(a);
        this.nodes.put(a, n);
        return n;
    }

    public List<Object> sort() {
        OrderedHashSet visited = new OrderedHashSet();
        ArrayList<Object> sorted = new ArrayList<Object>();
        while (visited.size() < this.nodes.size()) {
            Node n2 = null;
            for (Node n2 : this.nodes.values()) {
                if (!visited.contains(n2)) break;
            }
            this.DFS(n2, visited, sorted);
        }
        return sorted;
    }

    public void DFS(Node n, Set<Node> visited, ArrayList<Object> sorted) {
        if (visited.contains(n)) {
            return;
        }
        visited.add(n);
        if (n.edges != null) {
            for (Node target : n.edges) {
                this.DFS(target, visited, sorted);
            }
        }
        sorted.add(n.payload);
    }

    public static class Node {
        Object payload;
        List<Node> edges;

        public Node(Object payload) {
            this.payload = payload;
        }

        public void addEdge(Node n) {
            if (this.edges == null) {
                this.edges = new ArrayList<Node>();
            }
            if (!this.edges.contains(n)) {
                this.edges.add(n);
            }
        }

        public String toString() {
            return this.payload.toString();
        }
    }
}

